% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.formula.R
\name{eco.formula}
\alias{eco.formula}
\title{Formula construction for ecogen objects}
\usage{
eco.formula(
  eco,
  formula,
  out.mode = c("formula", "expression"),
  expand.tables = "+"
)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{formula}{Formula with names of colums from the slots XY, P, G, A, E, or C}

\item{out.mode}{Output results explicit formula (default) or expression.}

\item{expand.tables}{method for tables coertion. Default is "+"}
}
\description{
When a data frame is present in a slot of an object, any individual column can be 
accessed using the notation: my_object@my_data_frame[, column_to_be_accessed]. The later constitutes an explicit 
name for the variable present in the object.  The present function generalizes this concept, 
allowing to construct a formula for the variables present in an ecogen object
(columns of the data frames in slots). The function creates an explicit formula that can be used
to parse ecogen objects into other functions (see examples below). For this purpose, each name in the 
formula is substituted with explicit names of columns if:

- The name corresponds to the name of an individual column in the data frames of the ecogen object, or

- The name is surrounded by U() and corresponds to the name of a slot. Complete data frames (as P, E, etc.) 
  or subsets (as U[, 1:5]) can be passed with this method and all the columns will be explicitly included in the formula.
  
  In other situations, names are not replaced.
}
\examples{
\dontrun{
require(vegan)
data(eco.test)

# Note that in this example "Condition" is not replaced; 
# the function Condition has a special meaning in rda,
# indicating conditioning variables; in eco.formula it is only text.

form <- eco.formula(eco, P1 + P2 + P3 + U(A) ~ E1 + E2 + Condition(X+Y))
rda(form)

form2 <- eco.formula(eco, P1 + P2 + P3 + U(A) ~ E1 + E2 + X + Y)
lm(form2)


# parsing with magrittr
eco.formula(eco, P1 + P2 + P3 + U(A) ~ U(E) + Condition(X+Y)) \%>\% rda
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
