% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{c_score}
\alias{c_score}
\title{CScore Co-occurrence Metric}
\usage{
c_score(m = matrix(rbinom(100, 1, 0.5), nrow = 10))
}
\arguments{
\item{m}{a binary presence-absence matrix in which rows are species and columns
are sites.}
}
\value{
Returns the average C-score calculated across all possible species pairs
in the matrix.
}
\description{
Takes a binary presence-absence matrix and returns
Stone and Roberts' (1990) C-score.
}
\details{
For each unique pair of species, the C-score is calculated as

\deqn{C_{ij} = (R_i - S)(R_j - S)}{C_ij = (R_i - S)(R_j - S)}

where R_i and R_j are the row sums for species i and j, and S is the number
of shared sites in which both species i and species j are present. For any
particular species pair, the larger the C-score, the more segregated the
pair, with fewer shared sites. However, the index can be difficult to
interpret when calculated as a matrix-wide average, because a single matrix
can contain individual pairs of species that are segregated, random, or aggregated.

Degenerate matrices result from simulations where a row or column sum may be 0. <nick can you fill in the implications as to what this means if they are included or not?>
}
\note{
The matrix-wide C-score is not calculated for missing species, so empty
rows in the matrix do not affect the result.
}
\examples{
obsCScore <- c_score(m=matrix(rbinom(100,1,0.5),nrow=10))
}
\references{
Stone. L. and A. Roberts. 1990. The checkerboard score and species
distributions. Oecologia 85: 74-79.

Gotelli, N.J. and W. Ulrich. 2010. The empirical Bayes approach as a tool to
identify non-random species associations. Oecologia 162:463-477.
}

