% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{checker}
\alias{checker}
\title{Checker Co-occurrence Metric}
\usage{
checker(m = matrix(rbinom(100, 1, 0.5), nrow = 10))
}
\arguments{
\item{m}{A binary presence-absence matrix in which rows are species and columns
are sites.}
}
\value{
Returns the number of unique species pairs that never co-occur.
}
\description{
Function to calculate number of unique pairs of species
that never co-occur and form a "checkerboard pair".
}
\details{
In Diamond's (1975) assembly rules model, pairs of species that
never co-occur in any site are interpreted as examples of interspecific competition.
A set of communities structured this way should contain more checkerboard
pairs than expected by chance.
}
\examples{
obsChecker <- checker(m=matrix(rbinom(100,1,0.5),nrow=10))
}
\references{
Diamond, J.M. 1975. Assembly of species communities. p. 342-444 in:
Ecology and Evolution of Communities. M.L. Cody and J.M. Diamond (eds.).
Harvard University Press, Cambridge.

Connor, E.F. and D. Simberloff. 1979. The assembly of species communities: chance
or competition? Ecology 60: 1132-1140.
}

