% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{czekanowski_var}
\alias{czekanowski_var}
\title{CzekanowskiVariance Niche Overlap Metric}
\usage{
czekanowski_var(m = matrix(rpois(80, 1), nrow = 10))
}
\arguments{
\item{m}{a matrix of resource utilization values.}
}
\value{
Returns the variance of the average pairwise niche overlap.
}
\description{
Takes a niche utilization matrix returns the variance of the
Czekanowski niche overlap index
}
\details{
A large value for variance implies that some species pairs show high
niche overlap and others show low niche overlap. A low value for variance
implies that niche overlap (high or low) is very similar among all species pairs.
}
\note{
The resource utilization matrix (rows = species, columns = discrete
resource categories) may include zeroes, but no negative numbers or missing
values. Relative resource within a species is first calculated, so the rows
need not sum to 1.0.
}
\examples{
obsVar <- czekanowski_var(m=matrix(rpois(40,0.5),nrow=8))
}
\references{
Winemiller, K.O. and E.R. Pianka. 1990. Organization in natural
assemblages of desert lizards and tropical fishes. Ecological Monographs 60:
27-55.
}
\seealso{
\code{\link{czekanowski}} niche overlap index.
}

