% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim4}
\alias{sim4}
\title{Sim4 Co-occurrence Randomization Algorithm}
\usage{
sim4(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and rowsums as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling elements
within each row.  Sampling weights for each column are proportional to
column sums. Makes a call to the vector_sample function.
}
\details{
This algorithm preserves differences among species in occurrence
frequencies, but assumes differences among sites in suitability are
proportional to observed species richness (= column sums).
}
\note{
This algorithm preserves differences in the commonness and rarity of
species (= rowsums), but assumes differences among sites in suitability are
proportional to observed species richness (= column sums). sim4 has a
somewhat high frequency of Type I errors with random matrices, so it is not
recommended for co-occurrence analysis.
}
\examples{
randomMatrix <- sim4(speciesData = matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.
}

