% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim8}
\alias{sim8}
\title{Sim8 Co-occurrence Randomization Algorithm}
\usage{
sim8(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and fill as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling all
elements. Columns are proportional to column sums, and rows are proportional
to row sums. Makes a call to the vector_sample function.
}
\details{
This algorithm assumes that the probability that a species occurs
in a site is depends on the joint independent probability of randomly
selecting the species and randomly selecting the site, with these
probabilities set proportional to row and column sums of the matrix.
}
\note{
This algorithm is theoretically attractive because it incorporates
heterogeneity in species occurrences and species richness per site in a
probabilistic way that does not fix row and column frquencies. However,
in spite of its appeal, sim8 does not generate average row and column sums
that match the original matrix, and it is susceptible to Type I errors when
tested with random matrices. It is not recommended for co-occurrence
analysis. See Ulrich and Gotelli (2012) for a more complicated algorithm
for probabilistic row and column totals that has better statistical behavior.
}
\examples{
randomMatrix <- sim8(speciesData = matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. Ecology 81: 2606-2621.

Ulrich, W. and N.J. Gotelli. 2012. A null model algorithm for presence-
absence matrices based on proportional resampling. Ecological Modelling
244:20-27.
}

