% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{FuzzyIndice.plot.matlines}
\alias{FuzzyIndice.plot.matlines}
\title{Plot function for fuzzy indices with clustergram.}
\usage{
FuzzyIndice.plot.matlines(Z, k.range, x.range, z.range)
}
\arguments{
\item{Z}{Fuzzy indices matrix.}

\item{k.range}{x axis breaks.}

\item{x.range}{x axis range.}

\item{z.range}{y axis range for the fuzzy indices.}
}
\value{
A plot with the evolution of the fuzzy indices given the number of
  fuzzy clusters that were applied to the data.
}
\description{
Plot function for fuzzy indices with clustergram.
}
\details{
This function provide the tools to add a fuzzy indices evolution
  plot together with the normal clustegram plot with the evolution of the
  relative positions of the cluster centers.
}
\examples{
\donttest{
####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## clustergram plots with fuzzy indices plots:
   clustergramInd(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                                 clustering.function = clustergram.vegclust.Ind,
                                 clustergram.plot = clustergram.plot.matlines,
                                 FuzzyIndice.plot = FuzzyIndice.plot.matlines,
                                 k.range = 2:10, line.width = .2)
 }

}
