% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spinglass.R
\name{NetworkCommunity}
\alias{NetworkCommunity}
\title{Perform Spinglass algorythm and find networks communities}
\usage{
NetworkCommunity(networkeco, run = 100)
}
\arguments{
\item{networkeco}{A network object (either qgraph or igraph) or a list
created by the NetworkEco or NetworkEcoSeries functions.}

\item{run}{Number of runs for the spinglass algorithm. Computation may be
heavy for high numbers.}
}
\value{
A list containing the number of runs, the number of possible
  communities defined by the spinglass algorithm (with frequencies) and the
  mean and rounded mean of the assignement of the nodes of the network to
  these communities.
}
\description{
Perform Spinglass algorythm and find networks communities
}
\details{
The function perform spinglass algorithm on the provided network.
  (see spinglass.community() function of the igraph package for more details)
  The provided graph is internally transformed into a igraph object if
  needed. The function returns a number of summary statistics from the n runs
  of the spinglass algorithm. Each run of the spinglass algorithm is done
  with a different seed, to ensure different outputs. The seeds are internally
  recycled by the \emph{with_seed} fuction of the \emph{withr} package, so
  that the global environment is not modified.
  The frequencies at which a number of communities are recognised in the
  network and the average assignements (rounded or not) of the nodes into
  these communities are returned by the function. The latter can help
  to statistically define groups for network graphical representations.
}
\examples{
 #### Artificial data:
 SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.01,3)),
                                 pal = c("#008585", "#FBF2C4", "#C7522B"))

 # Building first network:
 Network <- DistEco(SyntheticTrial[,2:ncol(SyntheticTrial)],
                    transpose = TRUE, plot = c("network"), spinglass = FALSE,
                    return.network = TRUE)

 ### Spinglass algorithm (increase number of run for better accuracy):
 SpinglassTrial <- NetworkCommunity(Network, run = 5)

 ### Network with spinglass groups:
 DistEco(SyntheticTrial[,2:ncol(SyntheticTrial)], transpose = TRUE,
         plot = c("network"), spinglass = FALSE, return.network = FALSE,
         manual.groups = as.factor(SpinglassTrial$Memberships$RoundedMean))


}
