% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergram}
\alias{clustergram}
\title{Clustergram base function}
\usage{
clustergram(Data, k.range = 2:10,
  clustering.function = clustergram.kmeans,
  clustergram.plot = clustergram.plot.matlines, line.width = 0.004,
  add.center.points = TRUE, ...)
}
\arguments{
\item{Data}{Should be a scales matrix. Where each column belongs to a
different dimension of the observations}

\item{k.range}{A vector with the number of clusters to plot the clustergram
for.}

\item{clustering.function}{Which clustering method to be used. Default is
k-means. Can be FCM is set to clustergram.vegclust. See details}

\item{clustergram.plot}{Type of plot for the output. See details.}

\item{line.width}{Graphical parameter. Width of the lines.}

\item{add.center.points}{Logical. Should the cluster means be plotted (as
points).}

\item{...}{Additional arguments to be passed to the clustering function.}
}
\value{
A clustergram plot of the inputed data
}
\description{
Clustergram base function
}
\details{
This is the clustergram function created by Matthias Schonlau. See:
  Schonlau M. The clustergram: A graph for visualizing hierarchical and
  nonhierarchical cluster analyses. The Stata Journal. 2002;2:391–402.

  It is reproduced in this package for convenience. This package also provide
  extensions of the clustergram method for fuzzy-c-means clustering and for
  the evolution of the main fuzzy indices. These extensions take the form of
  additional options to be passed in the clustering.function argument and the
  clustergram.plot argument.

  It is also recommended to run the clustergram analysis several times and
  compare the obtained outputs, as they may vary significantly.
}
\examples{
   ####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## 6 clustergram plots
   for (i in 1:6) clustergram(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                              k.range = 2:10, line.width = .2)

}
