% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergram.vegclust.Ind}
\alias{clustergram.vegclust.Ind}
\title{Vegclust clustering with fuzzy indices computation for clustergram}
\usage{
clustergram.vegclust.Ind(Data, k, method = "FCM", ...)
}
\arguments{
\item{Data}{Should be a scales matrix. Where each column belongs to a
different dimension of the observations.}

\item{k}{Number of desired groups for the FCM clustering.}

\item{method}{Clustering method for the vegclust function.}

\item{...}{Additional parameters to be passed to the vegclust function.}
}
\value{
A list containing the cluster vector, the centers matrix and a vector
  of four fuzzy indices (partition coefficient (PC), normalized partition
  coefficient (PCN), partition entropy (PE) and normalized partition entropy
  (PEN)). See vegclust and veclustIndex functions.
}
\description{
Vegclust clustering with fuzzy indices computation for clustergram
}
\details{
Additionally to the FCM clustering, the function compute the main
  fuzzy indices to help with the decision on the optimal number of cluster in
  the data. Maximum values of PCN or minimum values of PEN can be used as
  criteria to choose the number of clusters.
}
\examples{
\donttest{
  ####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## clustergram plots with fuzzy indices plots:
   clustergramInd(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                                 clustering.function = clustergram.vegclust.Ind,
                                 clustergram.plot = clustergram.plot.matlines,
                                 FuzzyIndice.plot = FuzzyIndice.plot.matlines,
                                 k.range = 2:10, line.width = .2)
 }

}
