% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showCutPoints.R
\name{showCutPoints}
\alias{showCutPoints}
\title{Print a summary of achievement-level cut points.}
\usage{
showCutPoints(data)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}
}
\value{
A pasted statement that shows the achievement-level cut points
        associated with an \code{edsurvey.data.frame}
        or \code{light.edsurvey.data.frame}.
}
\description{
Print a summary of the achievement-level cut points on an
             \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# show the weights
showCutPoints(sdf)
}
