% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showWeights.R
\name{showWeights}
\alias{showWeights}
\title{Print out a summary of weights.}
\usage{
showWeights(data, verbose = FALSE)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}

\item{verbose}{logical. Set to TRUE to get jackknife replicate weights.}
}
\description{
Print out a summary of the weights in an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# show the weights
showWeights(data=sdf, verbose=TRUE)
}
\author{
Michael Lee and Paul Bailey
}
