% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBPS_2001.R
\name{readBPS_2001}
\alias{readBPS_2001}
\title{Beginning Postsecondary Students (BPS:96/01) Data}
\usage{
readBPS_2001(
  path = getwd(),
  csvFilename = "bps01derived_datafile.csv",
  formatFilename = "bps01derived_format.txt",
  metadataFilename = "bps01derived_metadata.txt"
)
}
\arguments{
\item{path}{a character value to the full directory path to the BPS extracted data files}

\item{csvFilename}{a character value of the derived data file (.csv) containing the raw BPS:96/01 data}

\item{formatFilename}{a character value of the format file (.txt) that describes the layout of the \code{csvFilename}}

\item{metadataFilename}{a character value of the metadata file (.txt) that describes additional metadata of the \code{csvFilename}}
}
\value{
An \code{edsurvey.data.frame} for the BPS longitudinal dataset.
}
\description{
Opens a connection to a BPS 1996 to 2001 cohort data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the unzipped derived data files from the BPS longitudinal database of the BPS 1996 to 2001 cohort.
}
\examples{
\dontrun{
# using default filenames
bps01 <- readBPS_2001(path = "~/BPS/2001")
dim(bps01)

# parameters specified without default filenames
bps01 <- readBPS_2001(path = getwd(),
                      csvFilename = "renamedData.csv",
                      formatFilename = "renamedFormat.txt",
                      metadataFilename = "renamedMeta.txt")
dim(bps01)
}
}
\seealso{
\code{\link{readBB_2012}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
