% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelsSDF.R
\name{levelsSDF}
\alias{levelsSDF}
\title{Print Levels and Labels}
\usage{
levelsSDF(varnames, data, showOmitted = TRUE, showN = TRUE)
}
\arguments{
\item{varnames}{a vector of character strings to search for in the database connection object (\code{data})}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}

\item{showOmitted}{a Boolean indicating if omitted levels should be shown}

\item{showN}{a Boolean indicating if (unweighted) \emph{n}-sizes should be shown for each response level}
}
\description{
Retrieve the levels and labels of a variable from an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# search variables in the sdf
levelsSDF(varnames="pared", data=sdf)

# search multiple variables
levelsSDF(varnames=c("pared","ell3"), data=sdf)

# search multiple variables in a light.edsurvey.data.frame with recodes
df2 <- getData(data=sdf, varnames=c("dsex", "t088301"),
               recode=list(t088301=list(from=c("Yes, available","Yes, I have access"),
                                        to=c("Yes")),
                           t088301=list(from=c("No, have no access"),
                                        to=c("No"))),
               addAttributes=TRUE)
levelsSDF(varnames=c("dsex","t088301"), data=df2)
}
}
\author{
Michael Lee and Paul Bailey
}
