% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.ini.maxeig.tri.R
\name{eff.ini.maxeig.tri}
\alias{eff.ini.maxeig.tri}
\title{Tridiagonal matrix maximal eigenpair}
\usage{
eff.ini.maxeig.tri(a, b, c, xi = 1, improved = F, digit.thresh = 6)
}
\arguments{
\item{a}{The lower diagonal vector.}

\item{b}{The upper diagonal vector.}

\item{c}{The shifted main diagonal vector. The corresponding unshift diagonal vector
is -c(b[1] + c[1], a[1:N - 1] + b[2:N] + c[2:N], a[N] + c[N + 1]) where N+1
is the dimension of matrix.}

\item{xi}{The coefficient used to form the convex combination of \eqn{\delta_1^{-1}} and
\eqn{(v_0,-Q*v_0)_\mu}, it should between 0 and 1.}

\item{improved}{With improved=T, the improved algorithm to calculate initial approximating
eigenpairs is used.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating sequence of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the maximal eigenpair for the tridiagonal matrix.
}
\examples{
a = c(1:7)^2
b = c(1:7)^2
c = rep(0, length(a) + 1)
c[length(a) + 1] = 8^2
eff.ini.maxeig.tri(a, b, c, xi = 1)

}
\seealso{
\code{\link{eff.ini.maxeig.general}} for the general matrix maximal eigenpair.
}
