% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompor.todos.R
\name{decompor.todos}
\alias{decompor.todos}
\title{Estimação de alternativas hipoteses}
\usage{
decompor.todos(y, X = NULL, comeco = NULL, fim = NULL, sazon.b = TRUE,
  regres = "S")
}
\arguments{
\item{y}{Série de tempo a ser decomposta}

\item{X}{Série de tempo das variáveis independentes}

\item{comeco}{Período inicial dos cálculos}

\item{fim}{Período final dos cálculos}

\item{sazon.b}{Boolean indicativa se o efeito sazonal será incorporado na forma funcional, Padrão = TRUE}

\item{regres}{Define que os coeficientes devem ser fixos no tempo ("F") ou estocásticos ("S")}
}
\value{
lista com os 8 modelos estimados
}
\description{
Função que calcula 8 formas funcionais para elasticidades para fins de comparação
}
\examples{
seriey <- ts(runif(96), start=1997, end=c(2015,4), frequency=4)
# Estimar modelo sem variáveis indepedentes
\donttest{ lista.dlm <- decompor.todos(seriey) }

seriex <- ts(runif(96), start=1997, end=c(2015,4), frequency=4)
# Estimar modelos incluindo variável independente
\donttest{ lista.dlm2 <- decompor.todos(y=seriey, X=seriex) }
# Estimar modelo, com variavel dependente, mas restringindo o escopo temporal
\donttest{ lista.dlm3 <- decompor.todos(y=seriey, X=seriex, comeco=2000, fim=2014) }
}
\seealso{
\code{\link{decompor}}
\code{\link{exportar}}
}
