% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo_steepness_from_sequence.R
\name{elo_steepness_from_sequence}
\alias{elo_steepness_from_sequence}
\title{steepness based on Bayesian Elo-rating}
\usage{
elo_steepness_from_sequence(
  winner,
  loser,
  algo = c("fixed_sd", "original"),
  silent = FALSE,
  ...
)
}
\arguments{
\item{winner}{character (or factor) of winning individuals}

\item{loser}{character (or factor) of losing individuals}

\item{algo}{character, either \code{"fixed_sd"} or \code{"original"}.
This determines which algorithm is used. Default is
\code{"fixed_sd"}, which is a slight modification from
Goffe et al's original code.}

\item{silent}{logical, suppress warnings (default is \code{FALSE})}

\item{...}{additional arguments for \code{sampling()}}
}
\value{
a list with results of the model fitting
(see \code{\link{elo_steepness_from_matrix}}) for details
}
\description{
for interaction data with known sequence of observations
}
\examples{
data(adv, package = "EloRating")
res <- elo_steepness_from_sequence(winner = adv$winner, loser = adv$loser,
                                   cores = 2, iter = 1000, warmup = 500,
                                   seed = 1, refresh = 0)
plot_steepness(res)

}
