% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONFIG_ALGO.R
\name{config_algo}
\alias{config_algo}
\title{Configuration object for algorithms}
\usage{
config_algo(
  algorithm_id,
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  ...
)
}
\arguments{
\item{algorithm_id}{id of the algorithm to be used. See \link[EmiR]{list_of_algorithms} for
the list of the available algorithms.}

\item{iterations}{maximum number of iterations.}

\item{population_size}{number of individuals in the population.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{...}{algorithm specific parameters (see specific configuration functions for more details).}
}
\value{
\code{config_algo} returns a configuration object specific for the specified algorithm.
}
\description{
Create a configuration object for one of the algorithms available in EmiR. At minimum the id of the
algorithm (parameter \code{algorithm_id}), the number of iterations (parameter \code{iterations}) and the
number of individuals in the population (parameter \code{population_size}) have to be provided.
}
\examples{
conf <- config_algo(algorithm_id = "PS", population_size = 200, iterations = 10000)

}
