% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EpiBayesSampleSize.R
\name{EpiBayesSampleSize}
\alias{EpiBayesSampleSize}
\title{Sample Size Search for EpiBayes Models}
\usage{
EpiBayesSampleSize(H.vect, k.vect, n.vect, season.vect, ...)
}
\arguments{
\item{H.vect}{Values of possible numbers of subzones. Integer vector.}

\item{k.vect}{Values of possible numbers of clusters within subzones. Integer vector.}

\item{n.vect}{Values of possible numbers of subjects within clusters within subzones.
Integer vector.}

\item{season.vect}{The single season in which one assumes sampling is taking place. Coded as
(1) Summer, (2) Fall, (3) Winter, (4) Spring. Integer scalar.}

\item{...}{Additional arguments that will be passed to \code{\link{EpiBayes_ns}}.
    Otherwise, the default values will be used.}
}
\value{
The returned values are given in a matrix. They are as follows.

\tabular{lll}{
    Output \tab Attributes \tab Description \cr
    \code{RawPost} \tab List: Length - (number of periods), Elements - Real arrays (\code{reps} x \code{H} x \code{MCMCreps}) \tab Posterior distributions for the cluster-level prevalences for each subzone from all time periods \cr
    \code{BetaBusterEst} \tab List: Length - (number of periods), Elements - Real vectors (2 x 1) \tab Estimated posterior distributions for the cluster-level prevalences for each subzone from all time periods using moment-matching to the closest beta distribution by the function \code{\link[epiR]{epi.betabuster}} \cr
    \code{ForOthers} \tab  \tab Various other data not intended to be used by the user, but used to pass information on to the \code{plot}, \code{summary}, and \code{print} methods \cr
}
}
\description{
This function takes three vectors for the number of subzones, clusters per subzone, and
    subjects per cluster per subzone and uses all combinations of the given values
    as inputs to \code{\link{EpiBayes_ns}} as a way to search for sample sizes which give
    optimal values of the Bayesian model output (e.g., \code{p4.tilde}). It assumes that
    at every sampling level, all elements have the same size (e.g., if the user supplies
    H = 2, k = 10, n = 100, then we assume that there are two subzones, both of which
    contain 10 clusters/farms/ponds/herds, and all clusters in all subzones contain
    100 subjects/individuals/mollusks/cows/chickens). This is done for computational
    efficiency in the search.
}
\examples{
testrun_samplesize = EpiBayesSampleSize(
		H = c(2, 4),
		k = c(10, 20),
		n = c(100, 500),
		season = 3,
		burnin = 1,
		reps = 1,
		MCMCreps = 10,
		tau.T = 0,
		poi = "tau",
		mumodes = matrix(c(
			0.50, 0.70,
			0.50, 0.70,
			0.02, 0.50,
			0.02, 0.50
			), 4, 2, byrow = TRUE
		),
		pi.thresh = 0.05,
	    tau.thresh = 0.02,
     gam.thresh = 0.10,
		poi.lb = 0.1,
		poi.ub = 0.4,
		p1 = 0.95,
		psi = 4,
		tauparm = c(1, 1),
		omegaparm = c(1000, 1),
		gamparm = c(1000, 1),
		etaparm = c(100, 6),
		thetaparm = c(100, 6)
		)

testrun_samplesize
print(testrun_samplesize, out.ptilde = "p4.tilde")
}

