\name{SIRBirthDeath}
\alias{SIRBirthDeath}
\title{SIR model with births and deaths (P 2.2).}
\usage{
SIRBirthDeath(pars = NULL, init = NULL, time = NULL, ...)
}
\arguments{
  \item{pars}{\code{\link{vector}} with 3 values: the per
  capita death rate (equal to the population level birth
  rate), the transmission rate, and the recovery rate. The
  names of these values must be "mu", "beta", and "gamma",
  respectively.}

  \item{init}{\code{\link{vector}} with 3 values: the
  initial proportion of proportion of susceptibles,
  infectious and recovered. The names of these values must
  be "S", "I" and "R", respectively. All parameters must be
  positive and S + I + 0 <= 1.}

  \item{time}{time sequence for which output is wanted; the
  first value of times must be the initial time.}

  \item{...}{further arguments passed to
  \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{*$model}, is
the model function. The second, third and fourth elements
are the vectors \code{*$pars}, \code{*$init},
\code{*$time}, containing the \code{pars}, \code{init} and
\code{time} arguments of the function. The fifth element
\code{*$results} is a \code{\link{data.frame}} with up to
as many rows as elements in time. First column contains the
time. Second, third and fourth columns contain the
proportion of susceptibles, infectious and recovered.
}
\description{
Solves a simple SIR model with equal births and deaths.
}
\details{
This is the R version of program 2.2 from page 27 of
"Modeling Infectious Disease in humans and animals" by
Keeling & Rohani.
}
\examples{
# Parameters and initial conditions.
parameters <- c(mu = 1 / (70 * 365),
                       beta = 520 / 365, gamma = 1 / 7)
initials <- c(S = 0.1, I = 1e-4, R = 1 - 0.1 - 1e-4)

# Solve the system.
sir.birth.death <- SIRBirthDeath(pars = parameters, init = initials,
                                 time = 0:(60 * 365))
}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious
diseases in humans and animals. Princeton University Press,
2008.
\href{http://www.modelinginfectiousdiseases.org/}{Modeling
Infectious Diseases in Humans and Animals}
}
\seealso{
\link[deSolve]{ode}.
}

