% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epilps.R
\name{epilps}
\alias{epilps}
\title{Estimation of the time-varying reproduction number with Laplacian-P-splines}
\usage{
epilps(incidence, K = 30, method = c("LPSMAP","LPSMALA"),
       serial_interval, penorder = 2, hyperprior = c(10,10),
       chain_length = 5000, burn = 2000, progmala = TRUE, ci_level = 0.95,
       verbose = TRUE, dates = NULL, tictoc = FALSE)
}
\arguments{
\item{incidence}{A vector containing the case counts per unit of time.}

\item{K}{Number of (cubic) B-splines in the basis.}

\item{method}{Either LPSMAP (fully sampling-free) or LPSMALA (MCMC-based).}

\item{serial_interval}{The serial interval distribution.}

\item{penorder}{The order of the penalty (Default is second-order).}

\item{hyperprior}{Parameters for the Gamma prior on the dispersion parameter.}

\item{chain_length}{The length of the MCMC chain for method "LPSMALA"
(default 5,000).}

\item{burn}{The warm up period for method "LPSMALA" (default 2,000).}

\item{progmala}{Should the progress bar of LPSMALA be shown? (default TRUE).}

\item{ci_level}{Level of the credible intervals to be computed.}

\item{verbose}{Should metainformation be printed?}

\item{dates}{A vector of date values (optional).}

\item{tictoc}{Should routine timing (in seconds) be measured?}
}
\value{
An object of class \code{epilps} containing the pointwise and set
 estimates of the time-varying reproduction number and the epidemic curve
 respectively.
}
\description{
This routine estimates the instantaneous reproduction number (the mean number
of secondary cases generated by infectious individuals at time t, White et
al. (2020)) using Bayesian P-splines and Laplace approximations. Two
methods are possible for inference. LPSMAP is a fully sampling-free approach
based on Laplace approximations to the conditional posterior distribution of
the spline vector. LPSMALA is an MCMC-based approach based on Langevin
diffusions to sample the joint posterior of the model parameters. The
\code{epilps()} routine estimates R(t) based on a time series of case counts
and a given serial/generation interval distribution. The negative
Binomial distribution is used to model incidence count data and P-splines
(Eilers and Marx, 1996) are used to smooth the epidemic curve. The link
between the epidemic curve and the reproduction number is established via the
renewal equation. If \code{incidence} contains NA values at certain time
points, these are replaced by the average of the left- and right neighbor
counts. If the right neighbor is NA, the left neighbor is used as a
replacement value.
}
\examples{
si <- c(0.05, 0.05, 0.1, 0.1, 0.1, 0.1, 0.1, 0.05, 0.05, 0.1, 0.1, 0.1)
epidemic <- episim(serial_interval = si, Rpattern = 2)
epifit <- epilps(incidence = epidemic$y, K = 30, serial_interval = si)
plot(epifit)

}
\references{
Gressani, O., Wallinga, J., Althaus, C., Hens, N. and Faes, C.
 (2021). EpiLPS: a fast and flexible Bayesian tool for near real-time
 estimation of the time-varying reproduction number.
 \emph{MedRxiv preprint}.

White, L.F., Moser, C.B., Thompson, R.N., Pagano, M. (2021).
 Statistical estimation of the reproductive number from case notification
 data. \emph{American Journal of Epidemiology}, \strong{190}(4):611-620.

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing
 with B-splines and penalties. \emph{Statistical Science},
 \strong{11}(2):89-121.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
