% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.utils.R
\name{edgelist_censor}
\alias{edgelist_censor}
\title{Table of Edge Censoring}
\usage{
edgelist_censor(el)
}
\arguments{
\item{el}{A timed edgelist with start and end times extracted from a
\code{networkDynamic} object using the
\code{as.data.frame.networkDynamic} function.}
}
\value{
A 4 x 2 table containing the number and percent of edges in \code{el}
that are left-censored, right-censored, both-censored, or uncensored.
}
\description{
Outputs a table of the number and percent of edges that are
left-censored, right-censored, both-censored, or uncensored for
a \code{networkDynamic} object.
}
\details{
Given a STERGM simulation over a specified number of time steps, the edges
within that simulation may be left-censored (started before the first step),
right-censored (continued after the last step), right and left-censored, or
uncensored. The amount of censoring will increase when the average edge
duration approaches the length of the simulation.
}
\examples{
# Initialize and parameterize network model
nw <- network_initialize(n = 100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)

# Model estimation
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

# Simulate the network and extract a timed edgelist
dx <- netdx(est, nsims = 1, nsteps = 100, keep.tedgelist = TRUE,
      verbose = FALSE)
el <- as.data.frame(dx)

# Calculate censoring
edgelist_censor(el)

}
\keyword{netUtils}
