% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{comp_plot}
\alias{comp_plot}
\alias{comp_plot.dcm}
\alias{comp_plot.icm}
\alias{comp_plot.netsim}
\title{Plot Compartment Diagram for Epidemic Models}
\usage{
comp_plot(x, at, digits, ...)

\method{comp_plot}{dcm}(x, at = 1, digits = 3, run = 1, ...)

\method{comp_plot}{icm}(x, at = 1, digits = 3, ...)

\method{comp_plot}{netsim}(x, at = 1, digits = 3, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{dcm}, \code{icm}, or
\code{netsim}.}

\item{at}{Time step for model statistics.}

\item{digits}{Number of significant digits to print.}

\item{...}{Additional arguments passed to plot (not currently used).}

\item{run}{Model run number, for \code{dcm} class models with multiple runs
(sensitivity analyses).}
}
\description{
Plots a compartment flow diagram for deterministic compartmental
models, stochastic individual contact models, and stochastic
network models.
}
\details{
The \code{comp_plot} function provides a visual summary of an epidemic model
at a specific time step. The information contained in \code{comp_plot} is the
same as in the \code{summary} functions for a model, but presented
graphically as a compartment flow diagram.

For \code{dcm} class plots, specify the model run number if the model
contains multiple runs, as in a sensitivity analysis. For \code{icm} and
\code{netsim} class plots, the \code{run} argument is not used; the plots
show the means and standard deviations across simulations at the specified
time step.

These plots are currently limited to one-group models for each of the three
model classes. That functionality may be expanded in future software
releases.
}
\examples{
## Example 1: DCM SIR model with varying act.rate
param <- param.dcm(inf.prob = 0.2, act.rate = 5:7,
                   rec.rate = 1/3, a.rate = 1/90, ds.rate = 1/100,
                   di.rate = 1/35, dr.rate = 1/100)
init <- init.dcm(s.num = 1000, i.num = 1, r.num = 0)
control <- control.dcm(type = "SIR", nsteps = 25, verbose = FALSE)
mod1 <- dcm(param, init, control)
comp_plot(mod1, at = 25, run = 3)

## Example 2: ICM SIR model with 3 simulations
param <- param.icm(inf.prob = 0.2, act.rate = 3, rec.rate = 1/50,
                   a.rate = 1/100, ds.rate = 1/100,
                   di.rate = 1/90, dr.rate = 1/100)
init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
control <- control.icm(type = "SIR", nsteps = 25,
                       nsims = 3, verbose = FALSE)
mod2 <- icm(param, init, control)
comp_plot(mod2, at = 25, digits = 1)

}
\keyword{plot}
