% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.init.R
\name{initialize.net}
\alias{initialize.net}
\title{Initialization: netsim Module}
\usage{
initialize.net(x, param, init, control, s)
}
\arguments{
\item{x}{If \code{control$start == 1}, either a fitted network model object
of class \code{netest} or a list of such objects. If
\code{control$start > 1}, an object of class \code{netsim}. When
multiple networks are used, the node sets (including network size
and nodal attributes) are assumed to be the same for all networks.}

\item{param}{An \code{EpiModel} object of class \code{\link{param.net}}.}

\item{init}{An \code{EpiModel} object of class \code{\link{init.net}}.}

\item{control}{An \code{EpiModel} object of class \code{\link{control.net}}.}

\item{s}{Simulation number, used for restarting dependent simulations.}
}
\value{
A \code{netsim_dat} class main data object.
}
\description{
This function initializes the main \code{netsim_dat} class data
object on which data are stored, simulates the initial state of
the networks, and simulates disease status and other attributes.
}
\details{
When re-initializing a simulation, the \code{netsim} object passed
to \code{initialize.net} must contain the elements \code{param},
\code{nwparam}, \code{epi}, \code{attr}, \code{temp},
\code{coef.form}, and \code{num.nw}. If \code{tergmLite == TRUE} it
must also contain the elements \code{el} and \code{net_attr}. If
\code{tergmLite == FALSE} it must also contain the element
\code{network}.
}
\keyword{internal}
