% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{trim_netest}
\alias{trim_netest}
\title{Function to Reduce the Size of a \code{netest} Object}
\usage{
trim_netest(
  object,
  as.networkLite = TRUE,
  keep.fit = FALSE,
  keep = character(0)
)
}
\arguments{
\item{object}{A \code{netest} class object.}

\item{as.networkLite}{If \code{TRUE}, converts \code{object$newnetwork}
to a \code{networkLite}.}

\item{keep.fit}{If \code{FALSE}, removes the \code{object$fit} (if present)
on the \code{netest} object.}

\item{keep}{Character vector of object names to keep in formula environments.
By default, all objects are removed.}
}
\value{
A \code{netest} object with formula environments trimmed, optionally with the
\code{newnetwork} element converted to a \code{networkLite} and the
\code{fit} element removed.
}
\description{
Trims formula environments from the \code{netest} object.
Optionally converts the \code{newnetwork} element of the
\code{netest} object to a \code{networkLite} class, and removes
the \code{fit} element (if present) from the \code{netest}
object.
}
\details{
With larger, more complex network structures with epidemic models, it is
generally useful to reduce the memory footprint of the fitted TERGM model
object (estimated with \code{\link{netest}}). This utility function removes
all but the bare essentials needed for simulating a network model with
\code{\link{netsim}}.

The function always trims the environments of \code{object$constraints} and
\code{object$coef.diss$dissolution}.

When both \code{edapprox = TRUE} and \code{nested.edapprox = TRUE} in the
\code{netest} call, also trims the environments of \code{object$formula}
and \code{object$formation}.

When both \code{edapprox = TRUE} and \code{nested.edapprox = FALSE} in the
\code{netest} call, also trims the environments of \code{object$formula},
\code{environment(object$formation)$formation}, and
\code{environment(object$formation)$dissolution}.

When \code{edapprox = FALSE} in the \code{netest} call, also trims the
environments of \code{object$formation},
\code{environment(object$formula)$formation} and
\code{environment(object$formula)$dissolution}.

By default all objects are removed from these trimmed environments. Specific
objects may be retained by passing their names as the \code{keep} argument.
For the output of \code{trim_netest} to be usable in \code{\link{netsim}}
simulation, any objects referenced in the formulas should be included in the
\code{keep} argument.

If \code{as.networkLite = TRUE}, converts \code{object$newnetwork} to a
\code{networkLite} object. If \code{keep.fit = FALSE}, removes \code{fit} (if
present) from \code{object}.
}
\examples{
nw <- network_initialize(n = 100)
formation <- ~edges + concurrent
target.stats <- c(50, 25)
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 10)
est <- netest(nw, formation, target.stats, coef.diss,
              set.control.ergm = control.ergm(MCMC.burnin = 1e5,
                                              MCMC.interval = 1000))
print(object.size(est), units = "KB")

est.small <- trim_netest(est)
print(object.size(est.small), units = "KB")

}
