% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{global_map}
\alias{global_map}
\title{Generate a global map for a single variable.}
\usage{
global_map(
  data = NULL,
  variable = NULL,
  variable_label = NULL,
  trans = "identity",
  fill_labels = NULL,
  scale_fill = NULL,
  ...
)
}
\arguments{
\item{data}{Dataframe containing variables to be mapped. Must contain a \code{country} variable.}

\item{variable}{A character string indicating the variable to map data for. This must be supplied.}

\item{variable_label}{A character string indicating the variable label to use. If not supplied then the underlying
variable name is used.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{fill_labels}{A function to use to allocate legend labels. An example (used below) is \code{scales::percent},
which can be used for percentage data.}

\item{scale_fill}{Function to use for scaling the fill. Defaults to a custom \code{ggplot2::scale_fill_manual}, which
expects the possible values to be "Increasing", "Likely increasing", "Likely decreasing", "Decreasing" or "Unsure".}

\item{...}{Additional arguments passed to the \code{scale_fill} function}
}
\value{
A \code{ggplot2} object containing a global map.
}
\description{
This general purpose function can be used to generate a global map for a single variable. It has few defaults but
the data supplied must contain a \code{country} variable for linking to mapping data. This function requires the
installation of the \code{rnaturalearth} package.
}
\examples{
\donttest{
if(requireNamespace("rnaturalearth") & requireNamespace("scales")){
# Example 1 - categorical data
# If values are "Increasing", "Likely increasing" etc (see ?EpiNow2::theme_map), 
# then the default fill scale works
eg_data <- data.table::data.table(variable = c("Increasing", 
                                               "Decreasing", 
                                               "Unsure", 
                                               "Likely decreasing",
                                               "Likely increasing"),
                                  country = c("France", 
                                              "Germany", 
                                              "United Kingdom", 
                                              "Spain",
                                              "Australia") )
# Make variable a factor so the ordering is sensible in the legend
eg_data$variable <- factor(eg_data$variable, levels = c("Decreasing", "Likely decreasing",
                                                        "Unsure", "Likely increasing",
                                                        "Increasing"))
global_map(eg_data, variable = "variable", variable_label = "Direction\nof change")


# Example 2 - numeric data
# numeric data requires scale_fill and a global viridis_palette specified
eg_data$second_variable <- runif(nrow(eg_data))
viridis_palette <- "A"
global_map(eg_data, variable = "second_variable", scale_fill = scale_fill_viridis_c)
}
}
}
