// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_tune_inv_gamma_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_tune_inv_gamma");
    reader.add_event(43, 41, "end", "model_tune_inv_gamma");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
tail_delta(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta,
               const std::vector<T2__>& x_r,
               const std::vector<int>& x_i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        validate_non_negative_index("deltas", "2", 2);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> deltas(2);
        stan::math::initialize(deltas, DUMMY_VAR__);
        stan::math::fill(deltas, DUMMY_VAR__);
        current_statement_begin__ = 7;
        local_scalar_t__ alpha(DUMMY_VAR__);
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha, DUMMY_VAR__);
        stan::math::assign(alpha,stan::math::exp(get_base1(y, 1, "y", 1)));
        current_statement_begin__ = 8;
        local_scalar_t__ beta(DUMMY_VAR__);
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta, DUMMY_VAR__);
        stan::math::assign(beta,stan::math::exp(get_base1(y, 2, "y", 1)));
        current_statement_begin__ = 9;
        stan::math::assign(alpha, (logical_lte(alpha, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-6) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 10;
        stan::math::assign(beta, (logical_lte(beta, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-6) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 11;
        stan::math::assign(alpha, (logical_gte(alpha, 1e6) ? stan::math::promote_scalar<local_scalar_t__>(1e6) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 12;
        stan::math::assign(beta, (logical_gte(beta, 1e6) ? stan::math::promote_scalar<local_scalar_t__>(1e6) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 13;
        stan::model::assign(deltas, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    (inv_gamma_cdf(get_base1(theta, 1, "theta", 1), alpha, beta) - 0.01), 
                    "assigning variable deltas");
        current_statement_begin__ = 14;
        stan::model::assign(deltas, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                    ((1 - inv_gamma_cdf(get_base1(theta, 2, "theta", 1), alpha, beta)) - 0.01), 
                    "assigning variable deltas");
        current_statement_begin__ = 15;
        return stan::math::promote_scalar<fun_return_scalar_t__>(deltas);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct tail_delta_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& theta,
               const std::vector<T2__>& x_r,
               const std::vector<int>& x_i, std::ostream* pstream__) const {
        return tail_delta(y, theta, x_r, x_i, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_tune_inv_gamma
  : public stan::model::model_base_crtp<model_tune_inv_gamma> {
private:
        double u;
        double l;
        vector_d theta;
        double delta;
        double a;
        double b;
        vector_d y_guess;
        std::vector<double> x_r;
        std::vector<int> x_i;
        vector_d y;
public:
    model_tune_inv_gamma(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_tune_inv_gamma(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_tune_inv_gamma_namespace::model_tune_inv_gamma";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "u", "double", context__.to_vec());
            u = double(0);
            vals_r__ = context__.vals_r("u");
            pos__ = 0;
            u = vals_r__[pos__++];
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "l", "double", context__.to_vec());
            l = double(0);
            vals_r__ = context__.vals_r("l");
            pos__ = 0;
            l = vals_r__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 25;
            validate_non_negative_index("theta", "2", 2);
            theta = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            stan::math::fill(theta, DUMMY_VAR__);
            stan::math::assign(theta,transpose(stan::math::to_row_vector(stan::math::array_builder<double >().add(l).add(u).array())));
            current_statement_begin__ = 27;
            delta = double(0);
            stan::math::fill(delta, DUMMY_VAR__);
            stan::math::assign(delta,1);
            current_statement_begin__ = 28;
            a = double(0);
            stan::math::fill(a, DUMMY_VAR__);
            stan::math::assign(a,(square(((delta * (u + l)) / (u - l))) + 2));
            current_statement_begin__ = 29;
            b = double(0);
            stan::math::fill(b, DUMMY_VAR__);
            stan::math::assign(b,(((u + l) / 2) * (square(((delta * (u + l)) / (u - l))) + 1)));
            current_statement_begin__ = 30;
            validate_non_negative_index("y_guess", "2", 2);
            y_guess = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            stan::math::fill(y_guess, DUMMY_VAR__);
            stan::math::assign(y_guess,transpose(stan::math::to_row_vector(stan::math::array_builder<double >().add(stan::math::log(a)).add(stan::math::log(b)).array())));
            current_statement_begin__ = 32;
            validate_non_negative_index("x_r", "0", 0);
            x_r = std::vector<double>(0, double(0));
            stan::math::fill(x_r, DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("x_i", "0", 0);
            x_i = std::vector<int>(0, int(0));
            stan::math::fill(x_i, std::numeric_limits<int>::min());
            current_statement_begin__ = 35;
            validate_non_negative_index("y", "2", 2);
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            stan::math::fill(y, DUMMY_VAR__);
            stan::math::assign(y,algebra_solver(tail_delta_functor__(), y_guess, theta, x_r, x_i, pstream__));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_tune_inv_gamma() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_tune_inv_gamma_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 39;
            double alpha;
            (void) alpha;  // dummy to suppress unused var warning
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha, DUMMY_VAR__);
            stan::math::assign(alpha,stan::math::exp(get_base1(y, 1, "y", 1)));
            current_statement_begin__ = 40;
            double beta;
            (void) beta;  // dummy to suppress unused var warning
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,stan::math::exp(get_base1(y, 2, "y", 1)));
            // validate, write generated quantities
            current_statement_begin__ = 39;
            vars__.push_back(alpha);
            current_statement_begin__ = 40;
            vars__.push_back(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_tune_inv_gamma";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_tune_inv_gamma_namespace::model_tune_inv_gamma stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
