% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_secondary.R
\name{simulate_secondary}
\alias{simulate_secondary}
\title{Simulate a secondary observation}
\usage{
simulate_secondary(
  data,
  type = "incidence",
  family = "poisson",
  delay_max = 30,
  ...
)
}
\arguments{
\item{data}{A data frame containing the \code{date} of report and \code{primary}
cases as a numeric vector.}

\item{type}{A character string indicating the type of observation the
secondary reports are. Options include:
\itemize{
\item "incidence": Assumes that secondary reports equal a convolution of
previously observed primary reported cases. An example application is deaths
from an infectious disease predicted by reported cases of that disease (or
estimated infections).
\item "prevalence": Assumes that secondary reports are cumulative and are
defined by currently observed primary reports minus a convolution of
secondary reports. An example application is hospital bed usage predicted by
hospital admissions.
}}

\item{family}{Character string defining the observation model. Options are
Negative binomial ("negbin"), the default, Poisson ("poisson"), and "none"
meaning the expectation is returned.}

\item{delay_max}{Integer, defaulting to 30 days. The maximum delay used in
the convolution model.}

\item{...}{Additional parameters to pass to the observation model (i.e
\code{rnbinom} or \code{rpois}).}
}
\value{
A data frame containing simulated data in the format required by
\code{\link[=estimate_secondary]{estimate_secondary()}}.
}
\description{
Simulate a secondary observation
}
\examples{
# load data.table for manipulation
library(data.table)

#### Incidence data example ####

# make some example secondary incidence data
cases <- example_confirmed
cases <- as.data.table(cases)[, primary := confirm]

# Assume that only 40 percent of cases are reported
cases[, scaling := 0.4]

# Parameters of the assumed log normal delay distribution
cases[, meanlog := 1.8][, sdlog := 0.5]

# Simulate secondary cases
cases <- simulate_secondary(cases, type = "incidence")
cases
#### Prevalence data example ####

# make some example prevalence data
cases <- example_confirmed
cases <- as.data.table(cases)[, primary := confirm]

# Assume that only 30 percent of cases are reported
cases[, scaling := 0.3]

# Parameters of the assumed log normal delay distribution
cases[, meanlog := 1.6][, sdlog := 0.8]

# Simulate secondary cases
cases <- simulate_secondary(cases, type = "prevalence")
cases
}
\seealso{
estimate_secondary
}
\author{
Sam Abbott

Sebastian Funk
}
