% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{backcalc_opts}
\alias{backcalc_opts}
\title{Back Calculation Options}
\usage{
backcalc_opts(
  prior = c("reports", "none", "infections"),
  prior_window = 14,
  rt_window = 1
)
}
\arguments{
\item{prior}{A character string defaulting to "reports". Defines the prior
to use when deconvolving. Currently implemented options are to use smoothed
mean delay shifted reported cases ("reports"), to use the estimated
infections from the previous time step seeded for the first time step using
mean shifted reported cases ("infections"), or no prior ("none"). Using no
prior will result in poor real time performance. No prior and using
infections are only supported when a Gaussian process is present . If
observed data is not reliable then it a sensible first step is to explore
increasing the \code{prior_window} wit a sensible second step being to no longer
use reported cases as a prior (i.e set \code{prior = "none"}).}

\item{prior_window}{Integer, defaults to 14 days. The mean centred smoothing
window to apply to mean shifted reports (used as a prior during back
calculation). 7 days is minimum recommended settings as this smooths day of
the week effects but depending on the quality of the data and the amount of
information users wish to use as a prior (higher values equalling a less
informative prior).}

\item{rt_window}{Integer, defaults to 1. The size of the centred rolling
average to use when estimating Rt. This must be odd so that the central
estimate is included.}
}
\value{
A \verb{<backcalc_opts>} object of back calculation settings.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the optional arguments for the back calculation
of cases. Only used if \code{rt = NULL}.
}
\examples{
# default settings
backcalc_opts()
}
