% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Bonds_List_bis.R
\name{EN_Bonds_List_bis}
\alias{EN_Bonds_List_bis}
\title{Get the list of Bonds quoted on Euronext markets (Bis)}
\usage{
EN_Bonds_List_bis(target_page = 1)
}
\arguments{
\item{target_page}{Target page to retrieve. It can be a numerical value, 'Max' to designate the last pages, or the default value is 1 (which means first page).

Unlike the function \code{\link{EN_Bonds_List}}, this function allows you to specify a target page to retrieve from the list
of Bonds. For example, \code{EN_Bonds_List_bis(5)} fetches only the fifth page of the Bonds list, providing a more granular
control over the data retrieval process.}
}
\value{
A data frame containing information about Bonds, including name, ticker, ISIN code, market, last price, percentage change, and URL.
}
\description{
This function retrieves information about Bonds quoted on Euronext markets.
}
\examples{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)

dt_ = EN_Bonds_List_bis()  # To show only the 1st page, it is the defaut paramater
print(dt_)

\donttest{

dt_ = EN_Bonds_List_bis(10) # To show only the 10th page
print(dt_)


dt_ = EN_Bonds_List_bis('Max') # To show only last page
print(dt_)
}

}
\seealso{
\code{\link{EN_Stocks_List}} to get the list tickers infos quoted on a given Euronext Stock,
\code{\link{EN_Funds_List}} for Funds list,  \code{\link{EN_Indices_List}} for Indexes list,
\code{\link{EN_Etfs_List}}  for Etfs list

Other Infos Retrieval: 
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{Infos Retrieval}
