
<!-- 
<img src="https://raw.githubusercontent.com/aravind-j/EvaluateCore/master/inst/extdata/EvaluateCore.png" width="20%" />
-->

## `EvaluateCore`: Quality Evaluation of Core Collections <img src="https://raw.githubusercontent.com/aravind-j/EvaluateCore/master/inst/extdata/EvaluateCore.png" align="right" alt="logo" width="173" height = "200" style = "border: none; float: right;">

<!-- ###### Version : [0.1.1](https://aravind-j.github.io/EvaluateCore/); Copyright (C) 2015-2018: [ICAR-NBPGR](http://www.nbpgr.ernet.in/); License: [GPL-2|GPL-3](https://www.r-project.org/Licenses/) -->

##### *Aravind, J.<sup>1</sup>, Kaur, V.<sup>2</sup>, Wankhede, D. P.<sup>3</sup> and Nanjundan, J.<sup>4</sup>*

1.  Division of Germplasm Conservation, ICAR-National Bureau of Plant
    Genetic Resources, New Delhi.
2.  Division of Germplasm Evaluation, ICAR-National Bureau of Plant
    Genetic Resources, New Delhi.
3.  Division of Genomic Resources, ICAR-National Bureau of Plant Genetic
    Resources, New Delhi.
4.  ICAR-Indian Agricultural Research Institute, Regional Station,
    Wellington, Tamil Nadu.

-----

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN\_Status\_Badge](https://www.r-pkg.org/badges/version-last-release/EvaluateCore)](https://cran.r-project.org/package=EvaluateCore)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/EvaluateCore?color=green)](https://CRAN.R-project.org/package=EvaluateCore)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/aravind-j/EvaluateCore) -->
[![develVersion](https://img.shields.io/badge/devel%20version-0.1.0-orange.svg)](https://github.com/aravind-j/EvaluateCore)
<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/aravind-j/EvaluateCore/total.svg)] -->
[![Project Status:
WIP](http://www.repostatus.org/badges/latest/wip.svg)](http://www.repostatus.org/#wip)
[![lifecycle](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://www.tidyverse.org/lifecycle/#experimental)
<!-- [![Last-changedate](https://img.shields.io/badge/last%20change-2020--05--27-yellowgreen.svg)](/commits/master) -->
[![Rdoc](http://www.rdocumentation.org/badges/version/EvaluateCore)](http://www.rdocumentation.org/packages/EvaluateCore)
<!-- [![Zenodo DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1310011.svg)](https://doi.org/10.5281/zenodo.1310011) -->
[![Analytics](https://pro-pulsar-193905.appspot.com/UA-148941781-1/welcome-page)](https://github.com/aravind-j/google-analytics-beacon)

-----

## Description

Implements various quality evaluation statistics to assess the value of
plant germplasm core collections using qualitative and quantitative
phenotypic trait data according to Odong et al. (2015)
[doi:10.1007/s00122-012-1971-y](https://doi.org/10.1007/s00122-012-1971-y).

<!-- ## System Requirements
The function `dist.evaluate.core` is a wrapper around the `evaluateCore` function of the `corehunter` package which implemented in Java 8. Hence you need to have [Java Runtime Environment](http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html) (JRE) version 8 or higher for the package to work.-->

## Installation

<!-- The package can be installed from CRAN as follows: -->

The development version can be installed from github as follows:

``` r
# Install development version from Github
devtools::install_github("aravind-j/EvaluateCore")
```

<!-- ## Detailed tutorial
For a detailed tutorial (vignette) on how to used this package type:


```r
browseVignettes(package = 'EvaluateCore')
```
The vignette for the latest version is also available [online](https://aravind-j.github.io/EvaluateCore/articles.html).-->

## What’s new

To know whats new in this version type:

``` r
news(package='EvaluateCore')
```

## Links

<!-- [CRAN page](https://cran.r-project.org/package=EvaluateCore) -->

[Github page](https://github.com/aravind-j/EvaluateCore)

[Documentation website](https://aravind-j.github.io/EvaluateCore/)

<!-- [Zenodo DOI](https://doi.org/10.5281/zenodo.1310011) -->

## Citing `EvaluateCore`

To cite the methods in the package use:

``` r
citation("EvaluateCore")
```

``` 

To cite the R package 'EvaluateCore' in publications use:

  Aravind, J., Kaur, V., Wankhede, D. P. and Nanjundan, J. (2020).  EvaluateCore: Quality Evaluation of Core
  Collections. R package version 0.1.1, https://aravind-j.github.io/EvaluateCore/.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {EvaluateCore: Quality Evaluation of Core Collections},
    author = {J. Aravind and Vikender Kaur and Dhammaprakash Pandhari Wankhede and J. Nanjundan},
    year = {2020},
    note = {R package version 0.1.1},
    note = {https://aravind-j.github.io/EvaluateCore/},
  }

This free and open-source software implements academic research by the authors and co-workers. If you use it, please
support the project by citing the package.
```
