% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.evaluate.core.R
\name{shannon.evaluate.core}
\alias{shannon.evaluate.core}
\title{Shannon-Weaver Diversity Index}
\usage{
shannon.evaluate.core(data, names, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following columns. \item{Trait}{The qualitative
  trait.} \item{EC_H}{The Shannon-Weaver Diversity Index
  (\ifelse{html}{\out{<i>H'</i>}}{\eqn{H'}}) for EC.} \item{EC_H}{The
  Shannon-Weaver Diversity Index (\ifelse{html}{\out{<i>H'</i>}}{\eqn{H'}})
  for CS.} \item{EC_Hmax}{The Maximum diversity value
  (\ifelse{html}{\out{<i>H'<sub>max</sub></i>}}{\eqn{H'_{max}}}) for EC.}
  \item{CS_Hmax}{The Maximum diversity value
  (\ifelse{html}{\out{<i>H'<sub>max</sub></i>}}{\eqn{H'_{max}}}) for CS.}
  \item{EC_EH}{The Shannon Equitability Index
  (\ifelse{html}{\out{<i>E<sub>H</sub></i>}}{\eqn{E_{H}}}) for EC.}
  \item{CS_EH}{The Shannon Equitability Index
  (\ifelse{html}{\out{<i>E<sub>H</sub></i>}}{\eqn{E_{H}}}) for CS.}
}
\description{
Compute the Shannon-Weaver Diversity Index
(\ifelse{html}{\out{<i>H'</i>}}{\eqn{H'}}), Maximum diversity
(\ifelse{html}{\out{<i>H'<sub>max</sub></i>}}{\eqn{H'_{max}}}) and Shannon
Equitability Index (\ifelse{html}{\out{<i>E<sub>H</sub></i>}}{\eqn{E_{H}}})
\insertCite{shannon_mathematical_1949}{EvaluateCore} to compare the
phenotypic diversity for qualitative traits between entire collection (EC)
and core set (CS).
}
\details{
Shannon-Weaver Diversity Index (\ifelse{html}{\out{<i>H'</i>}}{\eqn{H'}}) is
computed as follows.

\ifelse{html}{\out{<p style="text-align: center;"><em>H' = &minus;
&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left: -1ex;">i=1</sub>
p<sub>i</sub>log(p<sub>i</sub>)</em></p>}}{\deqn{H' =
-\sum_{i=1}^{k}p_{i}log(p_{i})}}

Where \ifelse{html}{\out{<em>p<sub>i</sub></em>}}{\eqn{p_{i}}} denotes the
proportion in the group \ifelse{html}{\out{<em>k</em>}}{\eqn{k}}.

The maximum value of the index
(\ifelse{html}{\out{<em>H'<sub>max</sub></em>}}{\eqn{H'_{max}}}) is
\ifelse{html}{\out{ln(<em>k</em>)}}{\eqn{\ln(k)}}. This value occurs when
each group has the same frequency.

The Shannon equitability index
(\ifelse{html}{\out{<i>E<sub>H</sub></i>}}{\eqn{E_{H}}}) is the Shannon
diversity index divided by the maximum diversity.

\ifelse{html}{\out{<em><p style="text-align: center;"><em>E<sub>H</sub> =
<sup>H</sup></em> &frasl; <sub>ln(<em>k</em>)</sub></p></em>}}{\deqn{E_{H} =
\frac{H}{\ln{(k)}}}}
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

shannon.evaluate.core(data = ec, names = "genotypes",
                      qualitative = qual, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[psych:misc]{shannon}}
}
