% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentdiff.evaluate.core.R
\name{percentdiff.evaluate.core}
\alias{percentdiff.evaluate.core}
\title{Percentage Difference of Means and Variances}
\usage{
percentdiff.evaluate.core(data, names, quantitative, selected, alpha = 0.05)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{alpha}{Type I error probability (Significance level) of difference.}
}
\value{
A data frame with the values of
  \mjteqn{MD\\\%_{Hu}}{MD\\\\\\\%_{Hu}}{MD\%_{Hu}},
  \mjteqn{VD\\\%_{Hu}}{VD\\\\\\\%_{Hu}}{VD\%_{Hu}},
  \mjteqn{MD\\\%_{Kim}}{MD\\\\\\\%_{Kim}}{MD\%_{Kim}},
  \mjteqn{VD\\\%_{Kim}}{VD\\\\\\\%_{Kim}}{VD\%_{Kim}} and
  \mjteqn{\overline{d}D\\\%}{\overline{d}D\\\\\\\%}{\overline{d}D\%}.
}
\description{
Compute the following differences between the entire collection (EC) and core
set (CS). \itemize{ \item Percentage of significant differences of mean
(\mjteqn{MD\\\%_{Hu}}{MD\\\\\\\%_{Hu}}{MD\%_{Hu}})
\insertCite{hu_methods_2000}{EvaluateCore} \item Percentage of significant
differences of variance (\mjteqn{VD\\\%_{Hu}}{VD\\\\\\\%_{Hu}}{VD\%_{Hu}})
\insertCite{hu_methods_2000}{EvaluateCore} \item Average of absolute
differences between means
(\mjteqn{MD\\\%_{Kim}}{MD\\\\\\\%_{Kim}}{MD\%_{Kim}})
\insertCite{kim_powercore_2007}{EvaluateCore} \item Average of absolute
differences between variances
(\mjteqn{VD\\\%_{Kim}}{VD\\\\\\\%_{Kim}}{VD\%_{Kim}})
\insertCite{kim_powercore_2007}{EvaluateCore} \item Percentage difference
between the mean squared Euclidean distance among accessions
(\mjteqn{\overline{d}D\\\%}{\overline{d}D\\\\\\\%}{\overline{d}D\%})
\insertCite{studnicki_comparing_2013}{EvaluateCore} } \loadmathjax
}
\details{
The differences are computed as follows.

\mjtdeqn{MD\\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times
100}{MD\\\\\\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times
100}{MD\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times 100}

Where, \mjseqn{S_{t}} is the number of traits with a significant difference
between the means of the EC and the CS and \mjseqn{n} is the total number of
traits.

\mjtdeqn{VD\\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times
100}{VD\\\\\\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times
100}{VD\\%_{Hu} = \left ( \frac{S_{t}}{n} \right ) \times 100}

Where, \mjseqn{S_{t}} is the number of traits with a significant difference
between the variances of the EC and the CS and \mjseqn{n} is the total number
of traits.

\mjtdeqn{MD\\\%_{Kim} = \frac{1}{n}\sum_{i=1}^{n} \frac{\left |
M_{EC_{i}}-M_{CS_{i}} \right |}{M_{CS_{i}}}}{MD\\\\\\\%_{Kim} =
\frac{1}{n}\sum_{i=1}^{n} \frac{\left | M_{EC_{i}}-M_{CS_{i}} \right
|}{M_{CS_{i}}}}{MD\\%_{Kim} = \frac{1}{n}\sum_{i=1}^{n} \frac{\left |
M_{EC_{i}}-M_{CS_{i}} \right |}{M_{CS_{i}}}}

Where, \mjseqn{M_{EC_{i}}} is the mean of the EC for the \mjseqn{i}th trait,
\mjseqn{M_{CS_{i}}} is the mean of the CS for the \mjseqn{i}th trait and
\mjseqn{n} is the total number of traits.

\mjtdeqn{VD\\\%_{Kim} = \frac{1}{n}\sum_{i=1}^{n} \frac{\left |
V_{EC_{i}}-V_{CS_{i}} \right |}{V_{CS_{i}}}}{VD\\\\\\\%_{Kim} =
\frac{1}{n}\sum_{i=1}^{n} \frac{\left | V_{EC_{i}}-V_{CS_{i}} \right
|}{V_{CS_{i}}}}{VD\\%_{Kim} = \frac{1}{n}\sum_{i=1}^{n} \frac{\left |
V_{EC_{i}}-V_{CS_{i}} \right |}{V_{CS_{i}}}}

Where, \mjseqn{V_{EC_{i}}} is the variance of the EC for the \mjseqn{i}th
trait, \mjseqn{V_{CS_{i}}} is the variance of the CS for the \mjseqn{i}th
trait and \mjseqn{n} is the total number of traits.

\mjtdeqn{\overline{d}D\\\% =
\frac{\overline{d}_{CS}-\overline{d}_{EC}}{\overline{d}_{EC}} \times
100}{\overline{d}D\\\\\\\% =
\frac{\overline{d}_{CS}-\overline{d}_{EC}}{\overline{d}_{EC}} \times
100}{\overline{d}D\\% =
\frac{\overline{d}_{CS}-\overline{d}_{EC}}{\overline{d}_{EC}} \times 100}

Where, \mjseqn{\overline{d}_{CS}} is the mean squared Euclidean distance
among accessions in the CS and \mjseqn{\overline{d}_{EC}} is the mean squared
Euclidean distance among accessions in the EC.
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

percentdiff.evaluate.core(data = ec, names = "genotypes",
                          quantitative = quant, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[EvaluateCore]{snk.evaluate.core}},
  \code{\link[EvaluateCore]{snk.evaluate.core}}
}
