% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfdist.evaluate.core.R
\name{pdfdist.evaluate.core}
\alias{pdfdist.evaluate.core}
\title{Distance Between Probability Distributions}
\usage{
pdfdist.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following columns. \item{Trait}{The
  quantitative trait.} \item{KL_Distance}{The Kullback-Leibler distance
  \insertCite{kullback_information_1951}{EvaluateCore} between EC and CS.}
  \item{KS_Distance}{The Kolmogorov-Smirnov distance
  \insertCite{kolmogorov_sulla_1933,smirnov_table_1948}{EvaluateCore} between
  EC and CS.} \item{KS_pvalue}{The p value of the Kolmogorov-Smirnov
  distance.} \item{AD_Distance}{Anderson-Darling distance
  \insertCite{anderson_asymptotic_1952}{EvaluateCore} between EC and CS.}
  \item{AD_pvalue}{The p value of the Anderson-Darling distance.}
  \item{KS_significance}{The significance of the Kolmogorov-Smirnov distance
  (*: p \mjseqn{\leq} 0.01; **: p \mjseqn{\leq} 0.05; ns: p \mjseqn{>}
  0.05).} \item{AD_pvalue}{The significance of the Anderson-Darling distance
  (*: p \mjseqn{\leq} 0.01; **: p \mjseqn{\leq} 0.05; ns: p \mjseqn{>}
  0.05).}
}
\description{
Compute Kullback-Leibler
\insertCite{kullback_information_1951}{EvaluateCore}, Kolmogorov-Smirnov
\insertCite{kolmogorov_sulla_1933,smirnov_table_1948}{EvaluateCore} and
Anderson-Darling distances
\insertCite{anderson_asymptotic_1952}{EvaluateCore} between the probability
distributions of collection (EC) and core set (CS) for quantitative traits.
\loadmathjax
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

pdfdist.evaluate.core(data = ec, names = "genotypes",
                      quantitative = quant, selected = core)

}
\seealso{
\code{\link[entropy]{KL.plugin}}, \code{\link[stats]{ks.test}},
  \code{\link[kSamples]{ad.test}}
}
