% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treesWoffset.R
\name{drop.dummy.beast}
\alias{drop.dummy.beast}
\title{Remove dummy tip from beast summary trees, accounting for metadata on the tips}
\usage{
drop.dummy.beast(
  tree.file,
  output.file = NULL,
  dummy.name = "dummy",
  convert.heights = TRUE
)
}
\arguments{
\item{tree.file}{path to file containing the tree with dummy tip}

\item{output.file}{path to file to write converted tree. If \code{NULL} (default), the tree is simply returned.}

\item{dummy.name}{name of the added dummy tip, default \code{dummy}.}

\item{convert.heights}{whether height metadata should be converted to height - offset (required to plot e.g. HPD intervals correctly). Default TRUE.}
}
\value{
list of \code{tree} converted tree (as treedata) ; and \code{offset} age of the youngest tip in the final tree
}
\description{
This method is designed to remove the dummy tip added on offset trees once postprocessing is
complete (for instance once the summary tree has been built using TreeAnnotator).
}
\examples{
# Analyze the trees with dummy tips - for instance, calculate the MCC summary tree
# Then remove the dummy tip from the MCC tree
final_tree = drop.dummy.beast(system.file("extdata", "ex_offset.MCC.tre", package = "EvoPhylo"))

}
\seealso{
\code{\link[=drop.dummy.mb]{drop.dummy.mb()}} for the same function using summary trees with a "dummy" extant from Mr. Bayes
}
