% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get.power.betabinom}
\alias{get.power.betabinom}
\title{Estimate the power to compare two beta-binomial distributions.}
\usage{
get.power.betabinom(
  size,
  my.phi,
  my.p,
  my.alt.p,
  theory = FALSE,
  frequentist = FALSE,
  limit = FALSE
)
}
\arguments{
\item{size}{Number of samples from the beta-binomial distribution.}

\item{my.phi}{Over-dispersion parameter.}

\item{my.p}{Expected p under the null.}

\item{my.alt.p}{Expected p under the alternative.}

\item{theory}{\code{logical}, should a theoretical limit (large sample size)
be used? Defaults to FALSE.}

\item{frequentist}{\code{logical}, should a frequentist version be used?
Defaults to FALSE.}

\item{limit}{\code{logical}, should another large sample size limit be used?
Defaults to FALSE.}
}
\value{
An expected Bayes factor.
}
\description{
A power study useful in the context of ExomeDepth.
}
\examples{
get.power.betabinom(size = 200, my.phi = 0.1, my.p = 0.2, my.alt.p = 0.6)
get.power.betabinom(size = 200, my.phi = 0.1, my.p = 0.2, my.alt.p = 0.2)
}
