% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_image.R
\name{split_image}
\alias{split_image}
\title{This function splits the image into several others (Esta funcao divide a
imagem em varias outras de acordo com os objetos que contem)}
\usage{
split_image(im,Seg,noise=0,CutImage=TRUE,lim=10,tolerance=1,ext=1,
  splitConnected=FALSE,colorBack=c(0,0,0) ,saveImage=TRUE,
  plot=T,col="red",cex=1,fileName="test.jpg")
}
\arguments{
\item{im}{Este objeto deve conter uma imagem no formato do EBImage.}

\item{Seg}{Este objeto deve ser obrigatoriamente uma matriz binaria, contendo
os valores 0 (pixels do background) ou 1 (pixels do foreground)).}

\item{noise}{E o numero de pixeis a partir do qual a funcao nao considerara
como ruido.}

\item{CutImage}{Se TRUE a imagem ao ser dividida ser cortada, englobando
apenas o objeto de interesse}

\item{lim}{Indica  numero de pixels que sera acrescentada nas bordas da
imagem cortada}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest. Tolerance should be chosen according to the range of
x. Default value is 1, which is a reasonable value if x comes from distmap.}

\item{ext}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Higher value smoothes out small objects.}

\item{splitConnected}{:Variavel do tipo logico. Se TRUE objetos encostados
serao considerados diferentes.}

\item{colorBack}{Deve ser um vetor com tres valores variando entre 0 a 1.
Estes valores indicam reespectivamente os valores de r, g e b que
substituirao os pixels indesejados nas imagens divididas.}

\item{saveImage}{Se for TRUE serao salvas as imagens dividas.}

\item{plot}{Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem segmentada}

\item{col}{Indica a cor do numero sobreposto sobre a imagem segmentada}

\item{cex}{Indica o tamanho do numero sobrepsosto sobre a imagem segmentada}

\item{fileName}{endereco e/ou nome do arquivo a ser salvo com extensao .jpg}
}
\value{
Retorna a medida em pixels dos objetos contidos na imagem e varias fotos
havendo em cada uma um objeto.
}
\description{
Esta funcao permite dividir a imagem e obter medidas dos objetos
}
\examples{
\donttest{
#remove(list=ls())
#require(ExpImage)
#require(EBImage)
im=read_image(example_image(3))
##mostrar imagem
plot(im)

g=gray_scale(im,"g",plot=TRUE)
Seg=segmentation(img.band = g,threshold = "otsu",selectHigher = FALSE,
fillHull = TRUE,plot = TRUE)

split_image(im=im,Seg=Seg,noise = 200,CutImage = FALSE,tolerance = 1,
saveImage = FALSE,plot = TRUE,col="blue",cex=2)
}
}
\seealso{
\code{\link{segmentation_logit}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
