% Generated by roxygen2 (4.0.2): do not edit by hand
\name{DistSelCriteriaValues}
\alias{DistSelCriteriaValues}
\title{Distribution Selection Criteria Values.}
\usage{
DistSelCriteriaValues(X, w = rep(1, length(X))/length(X),
  candDist = c("Beta_ab", "Laplace", "Normal"), criteria = c("logLik",
  "AIC", "AICc", "BIC", "MDL"))
}
\arguments{
\item{X}{obersevations.}

\item{w}{weights of sample.}

\item{candDist}{a vector of names of candidate distributions.}

\item{criteria}{a vector of criteria to be calculated}
}
\value{
a table contains mle parameter estimates and corresponding
distribution selection criteria values.
}
\description{
A function to calculate the distribution selection criteria
values for a list of candidate distributions
}
\details{
Details
}
\examples{
\donttest{
X <- rBeta_ab(30, a = 0, b = 1, shape1 = 2, shape2 = 10 )
DistSelCriteriaValues(X, candDist = c("Beta_ab","Laplace","Normal"),
                         criteria = c("logLik","AIC","AICc","BIC","MDL"))

w <- c(0.32, 1.77, 1.22, 0.64, 0.38, 0.93, 1.63, 1.34, 0.57, 1.73, 1.67, 0.67,
0.09, 1, 1.55, 0.53, 0.76, 1.06, 1.13, 1.31, 1.18, 1.64, 0.07, 1.41, 1.18,
0.69, 0.28, 1.27, 0.9, 1.08)
DistSelCriteriaValues(X, w, candDist = c("Beta_ab","Laplace","Normal"),
                             criteria = c("logLik","AIC","AICc","BIC","MDL"))
}
}

