% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairify_data.R
\name{fairify_data}
\alias{fairify_data}
\title{FAIRify Data}
\usage{
fairify_data(dataframe, domain, saveLocal = FALSE)
}
\arguments{
\item{dataframe}{User input metadata dataframe}

\item{domain}{Json-LD template to be filled by function \cr}

\item{saveLocal}{Boolean stating whether the files should be saved locally \cr
User can FAIRify data in the following domains: \cr \cr
PVModule \cr
Buildings \cr
CapillaryElectrophoresis \cr
GeospatialWell \cr
MetalAM \cr
OpticalProfilometry \cr
OpticalSpectroscopy \cr
PolymerAM \cr
PolymerBacksheets \cr
PVModule \cr
PVSystem \cr
XCT \cr
XRD}
}
\value{
FAIRified .json-ld text document
}
\description{
Function that receives user input metadata and converts that
into a FAIRified json-ld file based on a template created as part of this
package.
}
\examples{

metadata <- data.frame('CellMaterial' = 'mono-silicon',
                       'EncapsulantMaterial = EVA')

fairify_data(metadata, domain = 'PVModule', saveLocal = FALSE)
}
