% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{gaussian_tcch_log_likelihood}
\alias{gaussian_tcch_log_likelihood}
\title{Log likelihood function for Gaussian regression with parameter priors from BAS package}
\usage{
gaussian_tcch_log_likelihood(
  y,
  x,
  model,
  complex,
  mlpost_params = list(r = exp(-0.5), beta_prior = list(type = "intrinsic"))
)
}
\arguments{
\item{y}{A numeric vector containing the dependent variable.}

\item{x}{A matrix containing the independent variables, including an intercept column.}

\item{model}{A logical vector indicating which variables to include in the model.}

\item{complex}{A list containing complexity measures for the features.}

\item{mlpost_params}{A list of parameters for the log likelihood, specifying the tuning parameters of beta priors.}
}
\value{
A list with elements:
\item{crit}{Log marginal likelihood combined with the log prior.}
\item{coefs}{Posterior mode of the coefficients.}
}
\description{
This function computes the marginal likelihood of a Gaussian regression model under different priors.
}
\examples{
gaussian_tcch_log_likelihood(rnorm(100), matrix(rnorm(100)), c(TRUE), list(oc=1))

}
