% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-accessing-individual-weights}
\alias{mlp_get_w}
\alias{mlp_get_w_st}
\alias{mlp_net-accessing-individual-weights}
\alias{mlp_set_w}
\alias{mlp_set_w_st}
\title{Setting and retrieving status (on/off) and value of individual weight(s)}
\usage{
mlp_set_w_st(net, on, idx = NULL, layer = NULL, nidx = NULL,
  nplidx = NULL)

mlp_set_w(net, val, idx = NULL, layer = NULL, nidx = NULL,
  nplidx = NULL)

mlp_get_w_st(net, idx = NULL, layer = NULL, nidx = NULL, nplidx = NULL)

mlp_get_w(net, idx = NULL, layer = NULL, nidx = NULL, nplidx = NULL)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{on}{logical value (vector), should the weight be set on or off?}

\item{idx}{integer value (vector), weight absolute index}

\item{layer}{integer value (vector), layer index}

\item{nidx}{integer value (vector), neuron index}

\item{nplidx}{integer value (vector), index of the neuron in the previous
layer determining connection from neuron \code{nidx}
in \code{layer}, 0 denotes bias of neuron \code{nidx} in \code{layer}}

\item{val}{numeric value (vector), connection (or bias) value to be set}
}
\value{
\code{mlp_set_w_st} returns network (an object of \code{mlp_net} class)
                   with state(s) (on/off) of selected weight(s) set.

        \code{mlp_set_w} returns network (an object of \code{mlp_net} class)
                   with value(s) of selected weight(s) set.

        \code{mlp_get_w_st} returns logical value (vector), TRUE if connection/bias is active,
                   FALSE otherwise.

        \code{mlp_get_w} returns numeric value (vector), selected weight value(s).
}
\description{
The following functions can be used to access individual weight(s), i.e. set or
retrieve status(es) (on/off) and value(s).
}

