% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.cox}
\alias{power.cox}
\title{Compute the power of a single-predictor Cox regression model}
\usage{
power.cox(n, alpha, logHR, v)
}
\arguments{
\item{n}{number of events (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{logHR}{log hazard ratio (vector)}

\item{v}{variance of predictor variable (vector)}
}
\value{
Vector of power estimates for two-sided test
}
\description{
Use the formula of Hsieh and Lavori (2000) to compute the power of a single-predictor Cox model
}
\examples{
logHR = log(rep(c(1, 2),c(900, 100)));
v = rep(1, 1000);
res = power.cox(n = 50,alpha = 0.05,logHR = logHR, v = v)
}
\references{
Hsieh, FY and Lavori, Philip W (2000) Sample-size calculations for the Cox proportional hazards regression model with non-binary covariates. Controlled Clinical Trials 21(6):552-560.
}
