# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title Kernel functions
#'@name kernel
#'
#'@description
#'Kernel functions transform observed p-values or their support according to
#'[HLR], [PB] and [HGR]. The output is used by \code{\link{discrete.LR}},
#'\code{\link{discrete.PB}} and \code{\link{discrete.GR}}, respectively.
#'For each procedure, there is a kernel for fast computation and one for
#'calculation of critical values. Kernels followed by ".crit", e.g.
#'\code{kernel.DGR.crit}, compute and return these critical values, while
#'kernels ending in ".fast" only transform p-values and are therefore faster.
#'The end user should not use these functions directly.
#'
#'
#'@seealso
#'\code{\link{FDX-package}}, \code{\link{discrete.LR}}
#'\code{\link{discrete.GR}}, \code{\link{discrete.PB}},
#'\code{\link{weighted.LR}}, \code{\link{weighted.GR}},
#'\code{\link{discrete.PB}}
#'
#'@templateVar pCDFlist TRUE
#'@templateVar pvalues TRUE
#'@templateVar sorted_pv TRUE
#'@templateVar adaptive TRUE
#'@templateVar alpha TRUE
#'@templateVar stepUp TRUE
#'@templateVar zeta TRUE
#'@templateVar support TRUE
#'@templateVar exact TRUE
#'@templateVar raw.pvalues FALSE
#'@templateVar direction FALSE
#'@templateVar ret.crit.consts FALSE
#'@templateVar weights TRUE
#'@template param 
#'@param geom_weighting    a boolean specifying whether to conduct geometric
#'                         (\code{TRUE}) or arithmetic (\code{FALSE})
#'                         weighting.
#'@param qvalues           a numeric vector. Contains weighted raw p-values.
#'
#'@template example
#'@examples
#'
#'alpha <- 0.05
#'
#'# If not searching for critical constants, we use only the observed p-values
#'sorted.pvals <- sort(raw.pvalues)
#'y.DLR.fast <- kernel_DLR_fast(pCDFlist, sorted.pvals, TRUE)
#'y.NDGR.fast <- kernel_DGR_fast(pCDFlist, sorted.pvals, FALSE)
#'# transformed values
#'y.DLR.fast
#'y.NDGR.fast
#'
#'# compute support
#'pv.list <- sort(unique(unlist(pCDFlist)))
#'y.DGR.crit <- kernel_DGR_crit(pCDFlist, pv.list, sorted.pvals, TRUE)
#'y.NDPB.crit <- kernel_DPB_crit(pCDFlist, pv.list, sorted.pvals, FALSE)
#'# critical constants
#'y.DGR.crit$crit.consts
#'y.NDPB.crit$crit.consts
#'# transformed values
#'y.DGR.crit$pval.transf
#'y.NDPB.crit$pval.transf
#'
#'@return
#'For ".fast" kernels, a vector of transformed p-values is returned; ".crit"
#'kernels return a list object with critical constants (\code{$crit.consts})
#'and transformed p-values (\code{$pval.transf}).
#'
NULL

#'@rdname kernel
#'@export
kernel_DLR_fast <- function(pCDFlist, pvalues, adaptive = TRUE, alpha = 0.05, stepUp = FALSE, zeta = 0.5, support = 0L) {
    .Call('_FDX_kernel_DLR_fast', PACKAGE = 'FDX', pCDFlist, pvalues, adaptive, alpha, stepUp, zeta, support)
}

#'@rdname kernel
#'@export
kernel_DLR_crit <- function(pCDFlist, pvalues, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5, stepUp = FALSE) {
    .Call('_FDX_kernel_DLR_crit', PACKAGE = 'FDX', pCDFlist, pvalues, sorted_pv, adaptive, alpha, zeta, stepUp)
}

#'@rdname kernel
#'@export
kernel_DGR_fast <- function(pCDFlist, pvalues, adaptive = TRUE, alpha = 0.05) {
    .Call('_FDX_kernel_DGR_fast', PACKAGE = 'FDX', pCDFlist, pvalues, adaptive, alpha)
}

#'@rdname kernel
#'@export
kernel_DGR_crit <- function(pCDFlist, pvalues, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5) {
    .Call('_FDX_kernel_DGR_crit', PACKAGE = 'FDX', pCDFlist, pvalues, sorted_pv, adaptive, alpha, zeta)
}

#'@rdname kernel
#'@export
kernel_DPB_fast <- function(pCDFlist, pvalues, adaptive = TRUE, alpha = 0.05, exact = TRUE) {
    .Call('_FDX_kernel_DPB_fast', PACKAGE = 'FDX', pCDFlist, pvalues, adaptive, alpha, exact)
}

#'@rdname kernel
#'@export
kernel_DPB_crit <- function(pCDFlist, pvalues, sorted_pv, adaptive = TRUE, alpha = 0.05, zeta = 0.5, exact = TRUE) {
    .Call('_FDX_kernel_DPB_crit', PACKAGE = 'FDX', pCDFlist, pvalues, sorted_pv, adaptive, alpha, zeta, exact)
}

geom_weight <- function(pvalues, weights) {
    .Call('_FDX_geom_weight', PACKAGE = 'FDX', pvalues, weights)
}

#'@rdname kernel
#'@export
kernel_wLR_fast <- function(qvalues, weights, alpha = 0.05, geom_weighting = FALSE) {
    .Call('_FDX_kernel_wLR_fast', PACKAGE = 'FDX', qvalues, weights, alpha, geom_weighting)
}

#'@rdname kernel
#'@export
kernel_wGR_fast <- function(qvalues, weights, alpha = 0.05, geom_weighting = FALSE) {
    .Call('_FDX_kernel_wGR_fast', PACKAGE = 'FDX', qvalues, weights, alpha, geom_weighting)
}

#'@rdname kernel
#'@export
kernel_wPB_fast <- function(qvalues, weights, alpha = 0.05, geom_weighting = FALSE, exact = TRUE) {
    .Call('_FDX_kernel_wPB_fast', PACKAGE = 'FDX', qvalues, weights, alpha, geom_weighting, exact)
}

