% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmatrix.R
\name{[.hmatrix}
\alias{[.hmatrix}
\title{Extract or replace parts of a hmatrix-object}
\usage{
\method{[}{hmatrix}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{object from which to extract element(s) or in which to replace element(s).}

\item{i, j}{indices specifying elements to extract or replace. Indices are numeric 
vectors or empty (missing) or NULL. Numeric values are coerced to integer as by as.integer 
(and hence truncated towards zero).}

\item{...}{not used}

\item{drop}{If \code{TRUE} the result is coerced to the lowest possible dimension 
(or just a matrix). This only works for extracting elements, not for the 
replacement, defaults to \code{FALSE}.}
}
\description{
Operator acting on hmatrix preserving the attributes when rows are extracted.
}
\details{
If used on columns or rows/columns a matrix is returned. 
If used on rows only, i.e. x[i,] an object of class hmatrix is returned. 
The id is changed so that it runs from 1, ..., nNew, where nNew is the number of different 
id values in the new hmatrix-object. 
From the functional covariate \code{x} rows are selected accordingly.
}
\seealso{
?"["
}
