% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackscholes_impvol.R
\name{BlackScholesImpvol}
\alias{BlackScholesImpvol}
\title{Calculate Black-Scholes implied volatility}
\usage{
BlackScholesImpvol(
  price,
  strike = forward,
  spot,
  texp = 1,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{price}{(vector of) option price}

\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
Black-Scholes implied volatility
}
\description{
Calculate Black-Scholes implied volatility
}
\examples{
spot <- 100
strike <- 100
texp <- 1.2
sigma <- 0.2
intr <- 0.05
price <- 20
FER::BlackScholesImpvol(price, strike, spot, texp, intr=intr)

}
\references{
Giner, G., & Smyth, G. K. (2016). statmod: Probability Calculations
  for the Inverse Gaussian Distribution. The R Journal, 8(1), 339-351.
  \doi{10.32614/RJ-2016-024}
}
\seealso{
\code{\link{BlackScholesPrice}}
}
