% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{add_stats}
\alias{add_stats}
\title{Add decision statistics to data (based on frequency counts of a 2x2 classification outcomes)}
\usage{
add_stats(
  data,
  correction = 0.25,
  sens.w = NULL,
  my.goal = NULL,
  my.goal.fun = NULL,
  cost.outcomes = NULL,
  cost.each = NULL
)
}
\arguments{
\item{data}{A data frame with 4 frequency counts (as integer values, named \code{"hi"}, \code{"fa"}, \code{"mi"}, and \code{"cr"}).}

\item{correction}{numeric. Correction added to all counts for calculating \code{dprime}.
Default: \code{correction = .25}.}

\item{sens.w}{numeric. Sensitivity weight (for computing weighted accuracy, \code{wacc}).
Default: \code{sens.w = NULL} (to ensure that values are passed by calling function).}

\item{my.goal}{Name of an optional, user-defined goal (as character string).
Default: \code{my.goal = NULL}.}

\item{my.goal.fun}{User-defined goal function (with 4 arguments \code{hi fa mi cr}).
Default: \code{my.goal.fun = NULL}.}

\item{cost.outcomes}{list. A list of length 4 named \code{"hi"}, \code{"fa"}, \code{"mi"}, \code{"cr"}, and
specifying the costs of a hit, false alarm, miss, and correct rejection, respectively.
E.g.; \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that a
false alarm and miss cost 10 and 20 units, respectively, while correct decisions incur no costs.
Default: \code{cost.outcomes = NULL} (to ensure that values are passed by calling function).}

\item{cost.each}{numeric. An optional fixed cost added to all outputs (e.g., the cost of using the cue).
Default: \code{cost.each = NULL} (to ensure that values are passed by calling function).}
}
\value{
A data frame with variables of computed accuracy and cost measures (but dropping inputs).
}
\description{
\code{add_stats} assumes the input of the 4 essential classification outcomes
(as frequency counts in a data frame \code{"data"} with variable names \code{"hi"}, \code{"fa"}, \code{"mi"}, and \code{"cr"})
and uses them to compute various decision accuracy measures.
}
\details{
Providing numeric values for \code{cost.each} (as a vector) and \code{cost.outcomes} (as a named list)
allows computing cost information for the counts of corresponding classification decisions.
}
