% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datLUTnm.R
\name{datLUTnm}
\alias{datLUTnm}
\title{Data - Gets variable description or class.}
\usage{
datLUTnm(
  x,
  xvar = NULL,
  LUT = NULL,
  LUTvar = NULL,
  LUTnewvar = NULL,
  LUTnewvarnm = NULL,
  FIAname = FALSE,
  NAclass = "Other",
  group = FALSE,
  add0 = FALSE,
  stopifmiss = FALSE,
  xtxt = NULL,
  savedata = FALSE,
  savedata_opts = NULL,
  gui = FALSE
)
}
\arguments{
\item{x}{Data frame or comma-delimited file (*.csv). The data table with
variable to classify.}

\item{xvar}{String. Name of variable in the data table to join to.}

\item{LUT}{Data frame or comma-delimited file (*.csv). Name of the file with
collapsed classes (If FIAname=FALSE).}

\item{LUTvar}{String. Name of variable in LUT with values matching that
xvar.  If LUTvar=NULL, LUTvar=xvar.}

\item{LUTnewvar}{String. Name(s) of other variable(s) in the look-up table
to include in join. If NULL, all other variables in table will be included.}

\item{LUTnewvarnm}{String. Different name(s) for LUTnewvar. If NULL, names
will default to LUTnewvar. The length of LUTnewvarnm must equal the length
for LUTnewvar.}

\item{FIAname}{Logical. If TRUE, get FIA reference name based on (ref_codes)
within FIESTA.}

\item{NAclass}{String. NA values in xvar will be changed to NAclass.}

\item{group}{Logical. If TRUE, the group variables in reference table
(ref_codes) are merged to data table (GROUPCD, GROUPNM).}

\item{add0}{Logical. IF TRUE, keep all codes in look up table. If FALSE,
only include codes that are in x.}

\item{stopifmiss}{Logical. IF TRUE, stops function if missing codes in LUTx.}

\item{xtxt}{String.* Name of x table for more useful information in
warnings.}

\item{savedata}{Logical. If TRUE, saves data to outfolder.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE. If out_layer = NULL,
default = 'datlut'.}

\item{gui}{Logical. If gui, user is prompted for parameters.}
}
\value{
\item{xLUT}{ The input data table with look-up table variable(s). }
\item{xLUTnm}{ Name of the new variable(s). } \item{LUT}{ Look up table with
categories. }

If savedata = TRUE, a comma-delimited file is output to the outfolder as
outfn.  If outfn = NULL, the name of the file will be datlut_'date'.csv.
}
\description{
Merge a look-up table to append new variables, names, or categories to x.
}
\note{
For available reference tables:
sort(unique(ref_codes$VARIABLE))
}
\examples{
# Append forest type names using the reference table above.
ref_fortypcd <- ref_codes[ref_codes$VARIABLE == "FORTYPCD",]
WYcondlut <- datLUTnm(WYcond,
                      xvar = "FORTYPCD",
                      LUT = ref_fortypcd,
                      LUTvar = "VALUE",
                      LUTnewvar = "MEANING",
                      LUTnewvarnm = "FORTYPNM")
names(WYcondlut)
WYcond2 <- WYcondlut$xLUT
head(WYcond2[WYcond2$FORTYPCD > 0, ])

# Append forest type names the FIAname parameter. If the xvar is in the stored
# reference table, the name and values will automatically be appended.
WYcondlut2 <- datLUTnm(WYcond,
                       xvar = "FORTYPCD",
                       FIAname = TRUE)
names(WYcondlut2)
WYcond3 <- WYcondlut2$xLUT
head(WYcond3[WYcond3$FORTYPCD > 0, ])
}
\author{
Tracey S. Frescino
}
\keyword{data}
