% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datPlotcnt.R
\name{datPlotcnt}
\alias{datPlotcnt}
\title{Database - Get plot counts.}
\usage{
datPlotcnt(
  plt,
  yrtype = "INVYR",
  states = NULL,
  designcd = FALSE,
  forsamp = TRUE,
  total = TRUE,
  subtotal = TRUE,
  savedata = FALSE,
  outfolder = NULL,
  outfn = NULL,
  gui = FALSE
)
}
\arguments{
\item{plt}{Data frame. Table of plot-level variables to count plots. If
using this table, it must include INVYR.}

\item{yrtype}{String. Type of year to categorize data ("INVYR", "MEASYEAR").}

\item{states}{String vector.  The states in plt table.}

\item{designcd}{Logical. If TRUE, includes FIA design codes in the table.}

\item{forsamp}{Logical. If TRUE, includes forest/nonforest/nonsampled codes
in the table.}

\item{total}{Logical. If TRUE, a row is added to bottom of table with a
total for the whole table.}

\item{subtotal}{Logical. If TRUE, a row is added to bottom of each section
for subtotals.}

\item{savedata}{Logical. If TRUE, saves data to outfolder as comma-delimited
file (*.csv).  No objects are returned. If FALSE, the data are saved as R
objects and returned to user.  See details for caveats.}

\item{outfolder}{String. The output folder path. If NULL and savedata=TRUE
or parameters=TRUE, outfolder is the working directory.}

\item{outfn}{String. The name of the output file. If NULL, defaults to
pltcnt_'date'.csv}

\item{gui}{Logical. If TRUE, gui windows pop up for parameter selection.}
}
\value{
pltcnt - a dataframe of counts (YEAR, STABBR, STCD, PLOTS,
NONSAMPLED, FOREST, NONFOREST)
}
\description{
Extract plot counts by inventory year and state.
}
\author{
Tracey S. Frescino
}
\keyword{data}
