% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datSumTree.R
\name{datSumTree}
\alias{datSumTree}
\title{Data - Aggregates numeric tree data to the plot or condition-level.}
\usage{
datSumTree(
  tree = NULL,
  seed = NULL,
  cond = NULL,
  plt = NULL,
  subp_cond = NULL,
  subplot = NULL,
  datsource = "obj",
  data_dsn = NULL,
  tuniqueid = "PLT_CN",
  cuniqueid = "PLT_CN",
  puniqueid = "CN",
  bycond = FALSE,
  condid = "CONDID",
  bysubp = FALSE,
  subpuniqueid = "PLT_CN",
  subpid = "SUBP",
  tsumvarlst = NULL,
  tsumvarnmlst = NULL,
  TPA = TRUE,
  tfun = sum,
  ACI = FALSE,
  tfilter = NULL,
  addseed = FALSE,
  lbs2tons = TRUE,
  metric = FALSE,
  getadjplot = FALSE,
  adjtree = FALSE,
  adjvar = "tadjfac",
  adjTPA = 1,
  NAto0 = FALSE,
  tround = 5,
  checkNA = FALSE,
  returnDT = TRUE,
  savedata = FALSE,
  savedata_opts = NULL,
  gui = FALSE
)
}
\arguments{
\item{tree}{Dataframe or comma-delimited file (*.csv). The tree-level table.}

\item{seed}{Dataframe or comma-delimited file (*.csv). The seedling table.}

\item{cond}{Dataframe or comma-delimited file (*.csv). Condition-level table
to join the aggregated tree data to, if bycond=TRUE. This table also may be
used for condition proportion or strata variables used if adjcond or
adjstrata = TRUE (See details below).  This table is optional.}

\item{plt}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Plot-level table to join the aggregated tree data to, if bycond=FALSE. This
table is optional.}

\item{subp_cond}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot condition-level table to use to sum condition proportions, 
if bysubp=TRUE.}

\item{subplot}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot-level table to used to calculate adjustment factors, to remove 
nonsampled conditions (SUBP_STATUS_CD = 3). This table is optional. If 
included the aggregated tree data are joined to subplot before returning.}

\item{datsource}{String. Source of data ('obj', 'csv', 'sqlite', 'gdb').}

\item{data_dsn}{String. If datsource='sqlite', the name of SQLite database
(*.sqlite).}

\item{tuniqueid}{String. Unique identifier of plt in tree table.}

\item{cuniqueid}{String. Unique identifier of plt in cond table if cond is
NOT NULL.}

\item{puniqueid}{String. Unique identifier of plt table if plt is NOT NULL.}

\item{bycond}{Logical. If TRUE, the data are aggregated to the condition
level (by: cuniqueid, condid). If FALSE, the data are aggregated to the plot
level (by: puniqueid). If bysubp = TRUE and bycond = TRUE, data are 
aggregated by subpuniqueid, subpid, condid.}

\item{condid}{String. Unique identifier for conditions.}

\item{bysubp}{Logical. If TRUE, data are aggregated to the subplot level.}

\item{subpuniqueid}{String. Unique identifier of plot in subplot and 
subp_cond table.}

\item{subpid}{String. Unique identifier of each subplot.}

\item{tsumvarlst}{String (vector). Tree-level variable(s) to aggregate
(e.g., "TPA_UNADJ", "BA"). Use tsumvar="PLT_CN" (tfun=sum) for summed tree
count.}

\item{tsumvarnmlst}{String (vector). Name of the tree-level variable(s) to
aggregate (e.g., "TPALIVE", "BALIVE"). This list must have the same number
of variables as tsumvarlst and be in respective order. If NULL, the default
names will be tsumvar'_tfun' (e.g., "TPA_UNADJ_SUM", "BA_SUM").}

\item{TPA}{Logical. If TRUE, tsumvarlst variable(s) are multiplied by the
respective trees-per-acre variable (see details) to get per-acre
measurements.}

\item{tfun}{Function. The name of the function to use to aggregate the data
(e.g., sum, mean, max).}

\item{ACI}{Logical. If TRUE, if ACI (All Condition Inventory) plots exist,
any trees on these plots will be included in summary. If FALSE, you must
include condition table.}

\item{tfilter}{String. Filter to subset the tree data before aggregating
(e.g., "STATUSCD == 1"). This must be in R syntax. If tfilter=NULL, user is
prompted.  Use tfilter="NONE" if no filters.}

\item{addseed}{Logical. If TRUE, add seedling data to tree counts (if TPA
variable in tsumvarlst).}

\item{lbs2tons}{Logical. If TRUE, converts biomass or carbon variables from
pounds to tons. If metric=TRUE, converts to metric tons, else short tons.}

\item{metric}{Logical. If TRUE, converts response to metric units based on
FIESTA::ref_conversion, if any variable in tsumvarlst is in
FIESTAutils::ref_estvar.  Note: if TPA, TPA is converted to trees per hectare
(TPH: 1 / (1/ tpavar * 0.4046860)).}

\item{getadjplot}{Logical. If TRUE, adjustments are calculated for
nonsampled conditions on plot.}

\item{adjtree}{Logical. If TRUE, trees are individually adjusted by
adjustment factors.  Adjustment factors must be included in tree table (see
adjvar).}

\item{adjvar}{String. If adjtree=TRUE, the name of the variable to use for
multiplying by adjustment (e.g., tadjfac).}

\item{adjTPA}{Numeric. A tree-per-acre adjustment. Use for DESIGNCD=1
(annual inventory), if using less than 4 subplots. If using only 1 sublot
for estimate, adjTPA=4. The default is 1.}

\item{NAto0}{Logical. If TRUE, convert NA values to 0.}

\item{tround}{Number. The number of digits to round to. If NULL, default=6.}

\item{checkNA}{Logical. If TRUE, checks if NA values exist in necessary
variables.}

\item{returnDT}{Logical. If TRUE, returns data.table object(s). If FALSE,
returns data.frame object(s).}

\item{savedata}{Logical. If TRUE, saves data to outfolder.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE. If out_layer = NULL,
default = 'treesum'.}

\item{gui}{Logical. If gui, user is prompted for parameters.}
}
\value{
A list of the following items: \item{treedat}{ Data frame. Plot or
condition-level table with aggregated tree attributes. } \item{sumvars}{
String vector. Name(s) of the output aggregated tree attributes. }

If savedata=TRUE\cr - treedat will be saved to the outfolder. \cr - a text
file of input parameters is saved to outfolder
('outfn'_parameters_'date'.txt).
}
\description{
Aggregates numeric tree-level data (e.g., VOLCFNET) to plot or condition,
including options for filtering tree data or extrapolating to plot acre by
multiplying by TPA.
}
\details{
If variable = NULL, then it will prompt user for input.

Dependent external functions: datFilter Dependent internal functions:
addcommas, fileexistsnm, getadjfactor

For adjcond (bycond=FALSE): \cr If you want to summarize trees-per-acre
information aggregated to plot or condition level, you need to include a TPA
variable in tree table. \cr For tsumvars = GROWCFGS, GROWBFSL, GROWCFAL,
FGROWCFGS, FGROWBFSL, or FGROWCFAL, you must have TPAGROW_UNADJ \cr For
tsumvars = MORTCFGS, MORTBFSL, MORTCFAL, FMORTCFGS, FMORTBFSL, or FMORTCFAL,
you must have TPAMORT_UNADJ \cr For tsumvars = REMVCFGS, REMVBFSL, REMVCFAL,
FREMVCFGS, FREMVBFSL, or FREMVCFAL, you must have TPAREMV_UNADJ \cr

If you want to adjust plot-level or subplot-level information by condition 
proportions (adjplot), you need to include CONDID & CONDPROP_UNADJ in cond 
or tree table and COND_STATUS_CD. \cr
}
\note{
If a dat table is provided, the aggregated tree data will be merged to
table and NULL values will be output as 0.
}
\examples{
# Aggregate LIVE_CANOPY_CVR_PCT to plot, weighted by CONDPROP_UNADJ
treesum <- datSumTree(tree = FIESTA::WYtree,
                      tsumvarlst = "TPA_UNADJ")$treedat

# Check results
treesum[treesum$PLT_CN == 40404737010690,]
FIESTA::WYtree[FIESTA::WYtree$PLT_CN == 40404737010690,]
}
\author{
Tracey S. Frescino
}
\keyword{data}
