% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spImportSpatial.R
\name{spImportSpatial}
\alias{spImportSpatial}
\title{Spatial - Imports a spatial vector layer to an S4 Spatial object.}
\usage{
spImportSpatial(
  layer = NULL,
  dsn = NULL,
  sql = NULL,
  polyfix = FALSE,
  gui = FALSE
)
}
\arguments{
\item{layer}{Data frame object or String. Name of spatial layer. Can be
layer with dsn, full pathname, including extension, or file name (with
extension) in xy_dsn folder.}

\item{dsn}{String. Name of database where layer is. The dsn varies by
driver. See gdal OGR vector formats (https://www.gdal.org/ogr_formats.html).}

\item{sql}{String. A sql syntax query to subset spatial layer.}

\item{polyfix}{Logical. If polyfix=TRUE, uses buffer with 0 width to clean
up polygons.}

\item{gui}{Logical. If TRUE, search for layer within dsn.}
}
\value{
A spatial object
}
\description{
Imports a spatial vector layer to an S4 Spatial object.
}
\note{
Wrapper for sf package... st_read function.
}
\examples{
# Import data from `FIESTA`, save as object in environment
WYbh <- spImportSpatial(system.file("extdata",
                                    "sp_data/WYbighorn_adminbnd.shp",
                                    package = "FIESTA"))
}
\author{
Tracey S. Frescino
}
\keyword{data}
